/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.scheduler;

import de.adorsys.psd2.consent.repository.AisConsentJpaRepository;
import de.adorsys.psd2.consent.service.AisConsentConfirmationExpirationService;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class NotConfirmedConsentExpirationScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(NotConfirmedConsentExpirationScheduleTask.class);
    private final AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService;
    private final AisConsentJpaRepository aisConsentJpaRepository;

    @Scheduled(cron="${not-confirmed-consent-expiration.cron.expression}")
    @Transactional
    public void obsoleteNotConfirmedConsentIfExpired() {
        log.info("Not confirmed consent expiration schedule task is run!");
        List expiredNotConfirmedConsents = this.aisConsentJpaRepository.findByConsentStatusIn(EnumSet.of(ConsentStatus.RECEIVED)).stream().filter(arg_0 -> ((AisConsentConfirmationExpirationService)this.aisConsentConfirmationExpirationService).isConsentConfirmationExpired(arg_0)).collect(Collectors.toList());
        if (!expiredNotConfirmedConsents.isEmpty()) {
            this.aisConsentConfirmationExpirationService.updateConsentListOnConfirmationExpiration(expiredNotConfirmedConsents);
        }
    }

    @ConstructorProperties(value={"aisConsentConfirmationExpirationService", "aisConsentJpaRepository"})
    public NotConfirmedConsentExpirationScheduleTask(AisConsentConfirmationExpirationService aisConsentConfirmationExpirationService, AisConsentJpaRepository aisConsentJpaRepository) {
        this.aisConsentConfirmationExpirationService = aisConsentConfirmationExpirationService;
        this.aisConsentJpaRepository = aisConsentJpaRepository;
    }
}

