/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.scheduler;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public abstract class PageableSchedulerTask {
    @Value(value="${xs2a.cms.scheduler.processing.page-size:100}")
    protected int pageSize;

    protected void execute(long totalItems) {
        int totalPages = (int)((totalItems + (long)this.pageSize - 1L) / (long)this.pageSize);
        for (int page = 0; page < totalPages; ++page) {
            PageRequest pageable = PageRequest.of((int)page, (int)this.pageSize);
            this.executePageable((Pageable)pageable);
        }
    }

    protected abstract void executePageable(Pageable var1);
}

