/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.scheduler;

import de.adorsys.psd2.consent.repository.TppStopListRepository;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TppStopListScheduleTask {
    private static final Logger log = LoggerFactory.getLogger(TppStopListScheduleTask.class);
    private final TppStopListRepository tppStopListRepository;

    @Scheduled(cron="${xs2a.cms.stoplist.cron.expression}")
    @Transactional
    public void unblockTppIfBlockingExpired() {
        long start = System.currentTimeMillis();
        log.info("Tpp Stop List schedule task is run!");
        this.tppStopListRepository.unblockExpiredBlockedTpp();
        log.info("Tpp Stop List schedule task completed in {}ms!", (Object)(System.currentTimeMillis() - start));
    }

    @ConstructorProperties(value={"tppStopListRepository"})
    public TppStopListScheduleTask(TppStopListRepository tppStopListRepository) {
        this.tppStopListRepository = tppStopListRepository;
    }
}

