/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.integration.test;

import de.adorsys.psd2.integration.test.AbstractContainerDatabaseTest;
import de.adorsys.xs2a.reader.JsonReader;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ActiveProfiles;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.junit.jupiter.Container;

@ActiveProfiles(value={"integration-test"})
public class BaseTest
extends AbstractContainerDatabaseTest {
    protected JsonReader jsonReader = new JsonReader();
    @Container
    private static final PostgreSQLContainer postgreSQLContainer = new PostgreSQLContainer("postgres:11").withDatabaseName("consent").withUsername("admin").withPassword("secret");

    protected void clearData() {
        this.performQuery((JdbcDatabaseContainer)postgreSQLContainer, this.jsonReader.getStringFromFile("db/scripts/clear-data.sql"));
    }

    public static class Initializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        public void initialize(ConfigurableApplicationContext configurableApplicationContext) {
            if (!postgreSQLContainer.isRunning()) {
                postgreSQLContainer.start();
            }
            TestPropertyValues.of((String[])new String[]{"spring.datasource.url=" + postgreSQLContainer.getJdbcUrl(), "spring.datasource.username=" + postgreSQLContainer.getUsername(), "spring.datasource.password=" + postgreSQLContainer.getPassword(), "spring.jpa.show_sql=false"}).applyTo(configurableApplicationContext.getEnvironment());
        }
    }
}

