/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.integration.test;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.testcontainers.containers.JdbcDatabaseContainer;

public class AbstractContainerDatabaseTest {
    private static Connection connection;
    private HikariDataSource dataSource;

    void performQuery(JdbcDatabaseContainer container, String sql) {
        Connection connection = null;
        try {
            connection = this.getConnection(container);
        }
        catch (SQLException e) {
            Assertions.fail((String)("Connection creation failed: " + e.getMessage()));
        }
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            Assertions.fail((String)("Execution of sql statement failed: " + e.getMessage()));
        }
    }

    DataSource getDataSource(JdbcDatabaseContainer container) {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(container.getJdbcUrl());
        hikariConfig.setUsername(container.getUsername());
        hikariConfig.setPassword(container.getPassword());
        hikariConfig.setDriverClassName(container.getDriverClassName());
        this.dataSource = new HikariDataSource(hikariConfig);
        return this.dataSource;
    }

    private Connection getConnection(JdbcDatabaseContainer container) throws SQLException {
        if (connection != null && !connection.isClosed()) {
            return connection;
        }
        connection = this.getDataSource(container).getConnection();
        return connection;
    }

    @AfterAll
    static void afterAll() throws SQLException {
        if (connection != null && connection.isClosed()) {
            connection.close();
        }
    }
}

