/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.certificate.generator.service;

import de.adorsys.psd2.certificate.generator.exception.CertificateGeneratorException;
import de.adorsys.psd2.certificate.generator.model.IssuerData;
import de.adorsys.psd2.certificate.generator.service.KeysProvider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IssuerDataService {
    private static final Logger log = LoggerFactory.getLogger(IssuerDataService.class);
    private final KeysProvider keysProvider;
    private IssuerData issuerData;

    public IssuerDataService(KeysProvider keysProvider) {
        this.keysProvider = keysProvider;
        this.issuerData = this.generateIssuerData();
    }

    private IssuerData generateIssuerData() {
        IssuerData data = new IssuerData();
        X509Certificate cert = this.keysProvider.loadCertificate();
        try {
            data.setX500name(new JcaX509CertificateHolder(cert).getSubject());
        }
        catch (CertificateEncodingException ex) {
            throw new CertificateGeneratorException("Could not read issuer data from certificate", (Throwable)ex);
        }
        data.setPrivateKey(this.keysProvider.loadPrivateKey());
        return data;
    }

    public IssuerData getIssuerData() {
        return this.issuerData;
    }
}

