/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.certificate.generator.service;

import com.nimbusds.jose.util.X509CertUtils;
import de.adorsys.psd2.certificate.generator.exception.CertificateGeneratorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.springframework.stereotype.Component;

@Component
public class KeysProvider {
    private static final String ISSUER_PRIVATE_KEY = "MyRootCA.key";
    private static final String ISSUER_CERTIFICATE = "MyRootCA.pem";

    public PrivateKey loadPrivateKey() {
        InputStream stream = this.getResourceAsStream(ISSUER_PRIVATE_KEY);
        if (stream == null) {
            throw new CertificateGeneratorException("Could not read private key from classpath:certificates/MyRootCA.key");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            PEMParser pp = new PEMParser((Reader)br);
            PEMKeyPair pemKeyPair = (PEMKeyPair)pp.readObject();
            KeyPair kp = new JcaPEMKeyConverter().getKeyPair(pemKeyPair);
            pp.close();
            return kp.getPrivate();
        }
        catch (IOException ex) {
            throw new CertificateGeneratorException("Could not read private key from classpath", (Throwable)ex);
        }
    }

    public X509Certificate loadCertificate() {
        InputStream is = this.getResourceAsStream(ISSUER_CERTIFICATE);
        if (is == null) {
            throw new CertificateGeneratorException("Could not find certificate in classpath");
        }
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            return X509CertUtils.parse((byte[])bytes);
        }
        catch (IOException ex) {
            throw new CertificateGeneratorException("Could not read certificate from classpath", (Throwable)ex);
        }
    }

    private InputStream getResourceAsStream(String filename) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader.getResourceAsStream("certificates/" + filename);
    }
}

