/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.certificate.generator.service;

import com.nimbusds.jose.util.X509CertUtils;
import de.adorsys.psd2.certificate.generator.exception.CertificateGeneratorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class KeysProvider {
    @Value(value="${xs2a.certificate-generator.template.public.key:certificates/MyRootCA.key}")
    private String issuerPrivateKey;
    @Value(value="${xs2a.certificate-generator.template.private.key:certificates/MyRootCA.pem}")
    private String issuerCertificate;

    public PrivateKey loadPrivateKey() {
        InputStream stream = this.getResourceAsStream(this.issuerPrivateKey);
        if (stream == null) {
            throw new CertificateGeneratorException("Could not read private key from classpath:certificates/" + this.issuerPrivateKey);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            PEMParser pp = new PEMParser((Reader)br);
            PEMKeyPair pemKeyPair = (PEMKeyPair)pp.readObject();
            KeyPair kp = new JcaPEMKeyConverter().getKeyPair(pemKeyPair);
            pp.close();
            return kp.getPrivate();
        }
        catch (IOException ex) {
            throw new CertificateGeneratorException("Could not read private key from classpath", (Throwable)ex);
        }
    }

    public X509Certificate loadCertificate() {
        InputStream is = this.getResourceAsStream(this.issuerCertificate);
        if (is == null) {
            throw new CertificateGeneratorException("Could not find certificate in classpath");
        }
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            return X509CertUtils.parse((byte[])bytes);
        }
        catch (IOException ex) {
            throw new CertificateGeneratorException("Could not read certificate from classpath", (Throwable)ex);
        }
    }

    private InputStream getResourceAsStream(String path) {
        InputStream resourceAsStream = this.getResourceFromPath(path);
        if (resourceAsStream == null) {
            resourceAsStream = this.getFromGlobalPath(path);
        }
        return resourceAsStream;
    }

    private InputStream getResourceFromPath(String path) {
        return Optional.ofNullable(this.getClass().getClassLoader().getResourceAsStream(path)).orElse(this.getFromInnerPath(path));
    }

    private InputStream getFromInnerPath(String path) {
        return Optional.ofNullable(this.getClass().getResourceAsStream(path)).orElse(null);
    }

    private InputStream getFromGlobalPath(String path) {
        File initialFile = new File(path);
        try {
            return new FileInputStream(initialFile);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

