/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.web.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import de.adorsys.psd2.aspsp.profile.web.config.AspspProfileApiTagHolder;
import java.beans.ConstructorProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Tag;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class AspspProfileApiSwaggerConfig {
    @Value(value="${license.url}")
    private String licenseUrl;
    private final BuildProperties buildProperties;

    @Bean(name={"aspsp-profile-api"})
    public Docket apiDocklet() {
        return new Docket(DocumentationType.SWAGGER_2).groupName("ASPSP-PROFILE-API").apiInfo(this.getApiInfo()).tags(AspspProfileApiTagHolder.ASPSP_PROFILE, new Tag[]{AspspProfileApiTagHolder.UPDATE_ASPSP_PROFILE}).select().apis(RequestHandlerSelectors.basePackage((String)"de.adorsys.psd2.aspsp.profile")).paths(Predicates.not((Predicate)PathSelectors.regex((String)"/error.*?"))).paths(Predicates.not((Predicate)PathSelectors.regex((String)"/connect.*"))).paths(Predicates.not((Predicate)PathSelectors.regex((String)"/management.*"))).build();
    }

    private ApiInfo getApiInfo() {
        return new ApiInfoBuilder().title("ASPSP Profile rest API").contact(new Contact("pru, adorsys GmbH & Co. KG", "http://www.adorsys.de", "pru@adorsys.com.ua")).version(this.buildProperties.getVersion() + " " + this.buildProperties.get("build.number")).license("Apache License 2.0").licenseUrl(this.licenseUrl).build();
    }

    @ConstructorProperties(value={"buildProperties"})
    public AspspProfileApiSwaggerConfig(BuildProperties buildProperties) {
        this.buildProperties = buildProperties;
    }
}

