/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.web.controller;

import de.adorsys.psd2.aspsp.profile.domain.AspspSettings;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/v1/aspsp-profile"})
@Api(value="Aspsp profile", tags={"Aspsp profile"})
public class AspspProfileController {
    private final AspspProfileService aspspProfileService;

    @GetMapping
    @ApiOperation(value="Reads aspsp specific settings")
    @ApiResponse(code=200, message="Ok", response=AspspSettings.class)
    public ResponseEntity<AspspSettings> getAspspSettings() {
        return new ResponseEntity((Object)this.aspspProfileService.getAspspSettings(), HttpStatus.OK);
    }

    @GetMapping(path={"/sca-approaches"})
    @ApiOperation(value="Reads list of sca approaches")
    @ApiResponse(code=200, message="Ok", response=ScaApproach.class)
    public ResponseEntity<List<ScaApproach>> getScaApproaches() {
        return new ResponseEntity((Object)this.aspspProfileService.getScaApproaches(), HttpStatus.OK);
    }

    @ConstructorProperties(value={"aspspProfileService"})
    public AspspProfileController(AspspProfileService aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

