/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.web.controller;

import de.adorsys.psd2.aspsp.profile.domain.AspspSettings;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileUpdateService;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Profile(value={"debug_mode"})
@RestController
@RequestMapping(path={"/api/v1/aspsp-profile/for-debug"})
@Api(value="Update aspsp profile ", tags={"Update aspsp profile.  Only for DEBUG!"}, description="Provides access to update aspsp profile")
public class AspspProfileUpdateController {
    private final AspspProfileUpdateService aspspProfileService;

    @PutMapping(path={"/sca-approaches"})
    @ApiOperation(value="Updates list of sca approaches. Only for DEBUG!")
    @ApiResponses(value={@ApiResponse(code=200, message="Ok"), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<Void> updateScaApproach(@RequestBody List<String> newScaApproaches) {
        List scaApproaches = newScaApproaches.stream().map(s -> ScaApproach.valueOf((String)s.trim().toUpperCase())).collect(Collectors.toList());
        this.aspspProfileService.updateScaApproaches(scaApproaches);
        return new ResponseEntity(HttpStatus.OK);
    }

    @PutMapping(path={"/aspsp-settings"})
    @ApiOperation(value="Updates aspsp profile settings. Only for DEBUG!")
    @ApiResponses(value={@ApiResponse(code=200, message="Ok"), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<Void> updateAspspSettings(@RequestBody AspspSettings aspspSettings) {
        this.aspspProfileService.updateAspspSettings(aspspSettings);
        return new ResponseEntity(HttpStatus.OK);
    }

    @ConstructorProperties(value={"aspspProfileService"})
    public AspspProfileUpdateController(AspspProfileUpdateService aspspProfileService) {
        this.aspspProfileService = aspspProfileService;
    }
}

