/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.web.exception;

import de.adorsys.psd2.aspsp.profile.exception.AspspProfileConfigurationNotFoundException;
import de.adorsys.psd2.aspsp.profile.exception.InstanceIdIsMandatoryHeaderException;
import de.adorsys.psd2.aspsp.profile.web.exception.ErrorMessage;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ProfileExceptionAdvisor {
    private static final Logger logger = LoggerFactory.getLogger(ProfileExceptionAdvisor.class);

    @ExceptionHandler(value={AspspProfileConfigurationNotFoundException.class})
    public ResponseEntity<ErrorMessage> handleAspspProfileConfigurationNotFoundException(Exception ex) {
        ErrorMessage body = new ErrorMessage(MessageErrorCode.RESOURCE_UNKNOWN_404, ex.getMessage());
        logger.debug("Exception code: {}, \n message: {} \n", new Object[]{body.getCode(), ex.getMessage(), ex});
        return new ResponseEntity((Object)body, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={InstanceIdIsMandatoryHeaderException.class})
    public ResponseEntity<ErrorMessage> handleInstanceIdIsMandatoryHeaderException(Exception ex) {
        ErrorMessage body = new ErrorMessage(MessageErrorCode.FORMAT_ERROR, ex.getMessage());
        logger.debug("Exception code: {}, \n message: {} \n", new Object[]{body.getCode(), ex.getMessage(), ex});
        return new ResponseEntity((Object)body, HttpStatus.BAD_REQUEST);
    }
}

