/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.web.controller;

import de.adorsys.psd2.aspsp.profile.domain.migration.OldProfileConfiguration;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileConvertService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import org.springframework.context.annotation.Profile;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Profile(value={"debug_mode"})
@RestController
@RequestMapping(path={"/api/v1/aspsp-profile/convert-profile"}, consumes={"application/x-yaml"}, produces={"application/x-yaml"})
@Api(value="Convert old aspsp profile", tags={"Convert old aspsp profile to the new"})
public class AspspProfileConvertController {
    private final AspspProfileConvertService convertService;

    @PostMapping(path={"/aspsp-settings"})
    @ApiOperation(value="Converts old aspsp profile to the new format")
    @ApiResponses(value={@ApiResponse(code=200, message="Ok"), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity<String> convertAspspSetting(@RequestBody OldProfileConfiguration oldConfiguration) {
        return ResponseEntity.ok((Object)this.convertService.convertProfile(oldConfiguration));
    }

    @ConstructorProperties(value={"convertService"})
    public AspspProfileConvertController(AspspProfileConvertService convertService) {
        this.convertService = convertService;
    }
}

