/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import de.adorsys.psd2.aspsp.profile.config.CorsConfigProperties;
import de.adorsys.psd2.aspsp.profile.converter.YamlJackson2HttpMessageConverter;
import java.beans.ConstructorProperties;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebConfig
implements WebMvcConfigurer {
    private final CorsConfigProperties corsConfigProperties;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        ObjectMapper yamlMapper = new YAMLMapper().configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        converters.add((HttpMessageConverter<?>)new YamlJackson2HttpMessageConverter(yamlMapper));
    }

    @Bean
    public FilterRegistrationBean corsFilterRegistrationBean() {
        CorsConfiguration config = new CorsConfiguration();
        config.applyPermitDefaultValues();
        config.setAllowCredentials(this.corsConfigProperties.getAllowCredentials());
        config.setAllowedOrigins(this.corsConfigProperties.getAllowedOrigins());
        config.setAllowedHeaders(this.corsConfigProperties.getAllowedHeaders());
        config.setAllowedMethods(this.corsConfigProperties.getAllowedMethods());
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", config);
        return new FilterRegistrationBean((Filter)new CorsFilter((CorsConfigurationSource)source), new ServletRegistrationBean[0]);
    }

    @ConstructorProperties(value={"corsConfigProperties"})
    public WebConfig(CorsConfigProperties corsConfigProperties) {
        this.corsConfigProperties = corsConfigProperties;
    }
}

