/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.service;

import de.adorsys.psd2.aspsp.profile.config.ProfileConfiguration;
import de.adorsys.psd2.aspsp.profile.config.ProfileConfigurations;
import de.adorsys.psd2.aspsp.profile.exception.AspspProfileConfigurationNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

@Service
public class BankProfileReadingService
implements ResourceLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(BankProfileReadingService.class);
    private static final String DEFAULT_BANK_PROFILE = "classpath:bank_profile.yml";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String FILE_PREFIX = "file:";
    private static final String FILE_NOT_FOUND_ERROR_MESSAGE = "PSD2 api file is not found";
    @Value(value="${xs2a.bank_profile.path:}")
    private String customBankProfile;
    @Value(value="${xs2a.bank_profile.multitenancy.enabled:false}")
    private boolean multitenancyEnabled;
    @Value(value="#{${xs2a.bank_profile.multitenancy.customBankProfiles:{:}}}")
    private Map<String, String> customBankProfiles = new HashMap<String, String>();
    private ResourceLoader resourceLoader;
    private Yaml yaml = new Yaml(this.createRepresenter(), this.createDumperOptions());

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public ProfileConfigurations getProfileConfigurations() {
        HashMap<String, ProfileConfiguration> instanceConfigurations = new HashMap<String, ProfileConfiguration>();
        if (this.multitenancyEnabled) {
            this.customBankProfiles.keySet().forEach(key -> instanceConfigurations.put(key.toLowerCase(), (ProfileConfiguration)this.yaml.loadAs(this.loadProfile((String)key), ProfileConfiguration.class)));
        }
        ProfileConfiguration singleProfileConfiguration = (ProfileConfiguration)this.yaml.loadAs(this.loadProfile(), ProfileConfiguration.class);
        return new ProfileConfigurations(this.multitenancyEnabled, singleProfileConfiguration, instanceConfigurations);
    }

    private InputStream loadProfile() {
        Resource resource = this.resourceLoader.getResource(this.resolveBankProfile());
        try {
            return resource.getInputStream();
        }
        catch (IOException e) {
            log.error(FILE_NOT_FOUND_ERROR_MESSAGE, (Throwable)e);
            throw new IllegalArgumentException(FILE_NOT_FOUND_ERROR_MESSAGE);
        }
    }

    private InputStream loadProfile(String instanceId) {
        Resource resource = this.resourceLoader.getResource(this.resolveBankProfile(instanceId));
        try {
            return resource.getInputStream();
        }
        catch (IOException e) {
            log.error(FILE_NOT_FOUND_ERROR_MESSAGE, (Throwable)e);
            throw new IllegalArgumentException("PSD2 api file for `instance-id` " + instanceId + "is not found");
        }
    }

    private String resolveBankProfile(String instanceId) {
        if (this.multitenancyEnabled) {
            if (!this.customBankProfiles.containsKey(instanceId.toLowerCase())) {
                throw new AspspProfileConfigurationNotFoundException(instanceId);
            }
            return this.customBankProfiles.get(instanceId);
        }
        return this.resolveBankProfile();
    }

    private String resolveBankProfile() {
        if (StringUtils.isBlank((CharSequence)this.customBankProfile)) {
            return DEFAULT_BANK_PROFILE;
        }
        if (this.customBankProfile.startsWith(CLASSPATH_PREFIX) || this.customBankProfile.startsWith(FILE_PREFIX)) {
            return this.customBankProfile;
        }
        return FILE_PREFIX + this.customBankProfile;
    }

    private Representer createRepresenter() {
        Representer representer = new Representer();
        representer.getPropertyUtils().setSkipMissingProperties(true);
        return representer;
    }

    private DumperOptions createDumperOptions() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return options;
    }
}

