/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.service;

import de.adorsys.psd2.aspsp.profile.config.ProfileConfigurations;
import de.adorsys.psd2.aspsp.profile.service.BankProfileReadingService;
import java.beans.ConstructorProperties;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class BankProfileReloadingScheduleTask {
    private final BankProfileReadingService bankProfileReadingService;
    private final ProfileConfigurations profileConfigurations;

    @Scheduled(cron="${aspsp-profile-reload.cron.expression:-}")
    public void updateProfileConfiguration() {
        ProfileConfigurations newProfileConfiguration = this.bankProfileReadingService.getProfileConfigurations();
        this.profileConfigurations.updateSettings(newProfileConfiguration);
        this.profileConfigurations.setDefaultProperties();
    }

    @ConstructorProperties(value={"bankProfileReadingService", "profileConfigurations"})
    public BankProfileReloadingScheduleTask(BankProfileReadingService bankProfileReadingService, ProfileConfigurations profileConfigurations) {
        this.bankProfileReadingService = bankProfileReadingService;
        this.profileConfigurations = profileConfigurations;
    }
}

