/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.service;

import de.adorsys.psd2.aspsp.profile.config.BankProfileSetting;
import de.adorsys.psd2.aspsp.profile.config.ProfileConfigurations;
import de.adorsys.psd2.aspsp.profile.domain.AspspSettings;
import de.adorsys.psd2.aspsp.profile.mapper.AspspSettingsToBankProfileSettingMapper;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileUpdateService;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import java.beans.ConstructorProperties;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class AspspProfileUpdateServiceImpl
implements AspspProfileUpdateService {
    private final ProfileConfigurations profileConfigurations;
    private final AspspSettingsToBankProfileSettingMapper profileSettingMapper;

    public void updateScaApproaches(List<ScaApproach> scaApproaches, String instanceId) {
        this.profileConfigurations.getSetting(instanceId).getCommon().setScaApproachesSupported(scaApproaches);
    }

    public void updateAspspSettings(@NotNull AspspSettings aspspSettings, String instanceId) {
        BankProfileSetting setting = this.profileConfigurations.getSetting(instanceId);
        this.profileSettingMapper.updateBankProfileSetting(aspspSettings, setting);
    }

    public void enableMultitenancy(Boolean multitenancyEnabled) {
        this.profileConfigurations.setMultitenancyEnabled(multitenancyEnabled);
    }

    @ConstructorProperties(value={"profileConfigurations", "profileSettingMapper"})
    public AspspProfileUpdateServiceImpl(ProfileConfigurations profileConfigurations, AspspSettingsToBankProfileSettingMapper profileSettingMapper) {
        this.profileConfigurations = profileConfigurations;
        this.profileSettingMapper = profileSettingMapper;
    }
}

