/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.service;

import de.adorsys.psd2.aspsp.profile.config.BankProfileSetting;
import de.adorsys.psd2.aspsp.profile.config.ProfileConfigurations;
import de.adorsys.psd2.aspsp.profile.domain.AspspSettings;
import de.adorsys.psd2.aspsp.profile.domain.ais.AisAspspProfileBankSetting;
import de.adorsys.psd2.aspsp.profile.domain.ais.AisAspspProfileSetting;
import de.adorsys.psd2.aspsp.profile.domain.ais.AisRedirectLinkSetting;
import de.adorsys.psd2.aspsp.profile.domain.ais.AisTransactionSetting;
import de.adorsys.psd2.aspsp.profile.domain.ais.ConsentTypeBankSetting;
import de.adorsys.psd2.aspsp.profile.domain.ais.ConsentTypeSetting;
import de.adorsys.psd2.aspsp.profile.domain.ais.DeltaReportSetting;
import de.adorsys.psd2.aspsp.profile.domain.ais.OneTimeConsentScaBankSetting;
import de.adorsys.psd2.aspsp.profile.domain.ais.OneTimeConsentScaSetting;
import de.adorsys.psd2.aspsp.profile.domain.common.CommonAspspProfileBankSetting;
import de.adorsys.psd2.aspsp.profile.domain.common.CommonAspspProfileSetting;
import de.adorsys.psd2.aspsp.profile.domain.piis.PiisAspspProfileSetting;
import de.adorsys.psd2.aspsp.profile.domain.pis.PisAspspProfileBankSetting;
import de.adorsys.psd2.aspsp.profile.domain.pis.PisAspspProfileSetting;
import de.adorsys.psd2.aspsp.profile.domain.pis.PisRedirectLinkSetting;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.StartAuthorisationMode;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class AspspProfileServiceImpl
implements AspspProfileService {
    private final ProfileConfigurations profileConfigurations;

    public AspspSettings getAspspSettings(String instanceId) {
        BankProfileSetting setting = this.profileConfigurations.getSetting(instanceId);
        AisAspspProfileBankSetting aisBankSetting = setting.getAis();
        ConsentTypeBankSetting consentTypeSetting = aisBankSetting.getConsentTypes();
        ConsentTypeSetting consentTypes = new ConsentTypeSetting(consentTypeSetting.isBankOfferedConsentSupported(), consentTypeSetting.isGlobalConsentSupported(), consentTypeSetting.isAvailableAccountsConsentSupported(), consentTypeSetting.getAccountAccessFrequencyPerDay(), consentTypeSetting.getNotConfirmedConsentExpirationTimeMs(), consentTypeSetting.getMaxConsentValidityDays(), consentTypeSetting.isAccountOwnerInformationSupported(), consentTypeSetting.isTrustedBeneficiariesSupported());
        AisRedirectLinkSetting aisRedirectLinkToOnlineBanking = new AisRedirectLinkSetting(aisBankSetting.getRedirectLinkToOnlineBanking().getAisRedirectUrlToAspsp());
        AisTransactionSetting transactionParameters = new AisTransactionSetting(aisBankSetting.getTransactionParameters().getAvailableBookingStatuses(), aisBankSetting.getTransactionParameters().isTransactionsWithoutBalancesSupported(), aisBankSetting.getTransactionParameters().getSupportedTransactionApplicationTypes());
        DeltaReportSetting deltaReportSettings = new DeltaReportSetting(aisBankSetting.getDeltaReportSettings().isEntryReferenceFromSupported(), aisBankSetting.getDeltaReportSettings().isDeltaListSupported());
        OneTimeConsentScaBankSetting scaRequirementsForOneTimeConsentsBankSetting = aisBankSetting.getScaRequirementsForOneTimeConsents();
        OneTimeConsentScaSetting scaRequirementsForOneTimeConsents = new OneTimeConsentScaSetting(scaRequirementsForOneTimeConsentsBankSetting.isScaByOneTimeAvailableAccountsConsentRequired(), scaRequirementsForOneTimeConsentsBankSetting.isScaByOneTimeGlobalConsentRequired());
        AisAspspProfileSetting ais = new AisAspspProfileSetting(consentTypes, aisRedirectLinkToOnlineBanking, transactionParameters, deltaReportSettings, scaRequirementsForOneTimeConsents);
        PisAspspProfileBankSetting pisBankSetting = setting.getPis();
        PisRedirectLinkSetting pisRedirectLinkToOnlineBanking = new PisRedirectLinkSetting(pisBankSetting.getRedirectLinkToOnlineBanking().getPisRedirectUrlToAspsp(), pisBankSetting.getRedirectLinkToOnlineBanking().getPisPaymentCancellationRedirectUrlToAspsp(), pisBankSetting.getRedirectLinkToOnlineBanking().getPaymentCancellationRedirectUrlExpirationTimeMs());
        PisAspspProfileSetting pis = new PisAspspProfileSetting(pisBankSetting.getSupportedPaymentTypeAndProductMatrix(), pisBankSetting.getMaxTransactionValidityDays(), pisBankSetting.getNotConfirmedPaymentExpirationTimeMs(), pisBankSetting.isPaymentCancellationAuthorisationMandated(), pisRedirectLinkToOnlineBanking, pisBankSetting.getCountryValidationSupported(), pisBankSetting.getSupportedTransactionStatusFormats());
        PiisAspspProfileSetting piis = new PiisAspspProfileSetting(setting.getPiis().getPiisConsentSupported());
        CommonAspspProfileBankSetting commonBankSetting = setting.getCommon();
        CommonAspspProfileSetting common = new CommonAspspProfileSetting(commonBankSetting.getScaRedirectFlow(), commonBankSetting.getOauthConfigurationUrl(), commonBankSetting.getStartAuthorisationMode() == null ? StartAuthorisationMode.AUTO : StartAuthorisationMode.getByValue((String)commonBankSetting.getStartAuthorisationMode()), commonBankSetting.isTppSignatureRequired(), commonBankSetting.isPsuInInitialRequestMandated(), commonBankSetting.getRedirectUrlExpirationTimeMs(), commonBankSetting.getAuthorisationExpirationTimeMs(), commonBankSetting.isForceXs2aBaseLinksUrl(), commonBankSetting.getXs2aBaseLinksUrl(), commonBankSetting.getSupportedAccountReferenceFields(), commonBankSetting.getMulticurrencyAccountLevelSupported(), commonBankSetting.isAisPisSessionsSupported(), commonBankSetting.isSigningBasketSupported(), commonBankSetting.isCheckTppRolesFromCertificateSupported(), commonBankSetting.getAspspNotificationsSupported(), commonBankSetting.isAuthorisationConfirmationRequestMandated(), commonBankSetting.isAuthorisationConfirmationCheckByXs2a(), commonBankSetting.isCheckUriComplianceToDomainSupported(), commonBankSetting.getTppUriComplianceResponse());
        return new AspspSettings(ais, pis, piis, common);
    }

    public List<ScaApproach> getScaApproaches(String instanceId) {
        return this.profileConfigurations.getSetting(instanceId).getCommon().getScaApproachesSupported();
    }

    public boolean isMultitenancyEnabled() {
        return this.profileConfigurations.isMultitenancyEnabled();
    }

    @ConstructorProperties(value={"profileConfigurations"})
    public AspspProfileServiceImpl(ProfileConfigurations profileConfigurations) {
        this.profileConfigurations = profileConfigurations;
    }
}

