/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.service;

import de.adorsys.psd2.aspsp.profile.config.ProfileConfiguration;
import de.adorsys.psd2.aspsp.profile.service.BankProfileReadingService;
import java.beans.ConstructorProperties;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class BankProfileReloadingScheduleTask {
    private final BankProfileReadingService bankProfileReadingService;
    private final ProfileConfiguration profileConfiguration;

    @Scheduled(cron="${aspsp-profile-reload.cron.expression:-}")
    public void updateProfileConfiguration() {
        ProfileConfiguration newProfileConfiguration = this.bankProfileReadingService.getProfileConfiguration();
        this.profileConfiguration.setSetting(newProfileConfiguration.getSetting());
        this.profileConfiguration.setDefaultProperties();
    }

    @ConstructorProperties(value={"bankProfileReadingService", "profileConfiguration"})
    public BankProfileReloadingScheduleTask(BankProfileReadingService bankProfileReadingService, ProfileConfiguration profileConfiguration) {
        this.bankProfileReadingService = bankProfileReadingService;
        this.profileConfiguration = profileConfiguration;
    }
}

