/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.service;

import de.adorsys.psd2.aspsp.profile.config.BankProfileSetting;
import de.adorsys.psd2.aspsp.profile.config.ProfileConfiguration;
import de.adorsys.psd2.aspsp.profile.domain.AspspSettings;
import de.adorsys.psd2.aspsp.profile.mapper.AspspSettingsToBankProfileSettingMapper;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileUpdateService;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import java.beans.ConstructorProperties;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class AspspProfileUpdateServiceImpl
implements AspspProfileUpdateService {
    private final ProfileConfiguration profileConfiguration;
    private final AspspSettingsToBankProfileSettingMapper profileSettingMapper;

    @Override
    public void updateScaApproaches(List<ScaApproach> scaApproaches) {
        this.profileConfiguration.getSetting().getCommon().setScaApproachesSupported(scaApproaches);
    }

    @Override
    public void updateAspspSettings(@NotNull AspspSettings aspspSettings) {
        BankProfileSetting setting = this.profileConfiguration.getSetting();
        this.profileSettingMapper.updateBankProfileSetting(aspspSettings, setting);
    }

    @ConstructorProperties(value={"profileConfiguration", "profileSettingMapper"})
    public AspspProfileUpdateServiceImpl(ProfileConfiguration profileConfiguration, AspspSettingsToBankProfileSettingMapper profileSettingMapper) {
        this.profileConfiguration = profileConfiguration;
        this.profileSettingMapper = profileSettingMapper;
    }
}

