/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.mapper;

import de.adorsys.psd2.aspsp.profile.domain.ais.AisAspspProfileBankSetting;
import de.adorsys.psd2.aspsp.profile.domain.ais.AisRedirectLinkBankSetting;
import de.adorsys.psd2.aspsp.profile.domain.ais.AisTransactionBankSetting;
import de.adorsys.psd2.aspsp.profile.domain.ais.ConsentTypeBankSetting;
import de.adorsys.psd2.aspsp.profile.domain.ais.DeltaReportBankSetting;
import de.adorsys.psd2.aspsp.profile.domain.ais.OneTimeConsentScaBankSetting;
import de.adorsys.psd2.aspsp.profile.domain.common.CommonAspspProfileBankSetting;
import de.adorsys.psd2.aspsp.profile.domain.migration.NewBankProfileSetting;
import de.adorsys.psd2.aspsp.profile.domain.migration.NewPisAspspProfileBankSetting;
import de.adorsys.psd2.aspsp.profile.domain.migration.NewProfileConfiguration;
import de.adorsys.psd2.aspsp.profile.domain.migration.OldBankProfileSetting;
import de.adorsys.psd2.aspsp.profile.domain.migration.OldProfileConfiguration;
import de.adorsys.psd2.aspsp.profile.domain.piis.PiisAspspProfileBankSetting;
import de.adorsys.psd2.aspsp.profile.domain.pis.PisRedirectLinkBankSetting;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class NewProfileConfigurationMapper {
    private static final boolean DEFAULT_SCA_BY_ONE_TIME_GLOBAL_CONSENT_REQUIRED = true;

    public NewProfileConfiguration mapToNewProfileConfiguration(OldProfileConfiguration oldProfileConfiguration) {
        OldBankProfileSetting setting = oldProfileConfiguration.getSetting();
        ConsentTypeBankSetting consentTypes = new ConsentTypeBankSetting(setting.isBankOfferedConsentSupport(), setting.isAllPsd2Support(), setting.isAvailableAccountsConsentSupported(), setting.getFrequencyPerDay(), setting.getNotConfirmedConsentExpirationPeriodMs(), setting.getConsentLifetime(), false);
        AisRedirectLinkBankSetting aisRedirectLinkToOnlineBanking = new AisRedirectLinkBankSetting(setting.getAisRedirectUrlToAspsp());
        AisTransactionBankSetting transactionParameters = new AisTransactionBankSetting(setting.getAvailableBookingStatuses(), setting.isTransactionsWithoutBalancesSupported(), Optional.ofNullable(setting.getSupportedTransactionApplicationTypes()).orElse(Collections.emptyList()));
        DeltaReportBankSetting deltaReportSettings = new DeltaReportBankSetting(setting.isEntryReferenceFromSupported(), setting.isDeltaListSupported());
        OneTimeConsentScaBankSetting scaRequirementsForOneTimeConsents = new OneTimeConsentScaBankSetting(setting.isScaByOneTimeAvailableAccountsConsentRequired(), true);
        AisAspspProfileBankSetting ais = new AisAspspProfileBankSetting(consentTypes, aisRedirectLinkToOnlineBanking, transactionParameters, deltaReportSettings, scaRequirementsForOneTimeConsents);
        PisRedirectLinkBankSetting pisRedirectLinkToOnlineBanking = new PisRedirectLinkBankSetting(setting.getPisRedirectUrlToAspsp(), setting.getPisPaymentCancellationRedirectUrlToAspsp(), setting.getPaymentCancellationRedirectUrlExpirationTimeMs());
        NewPisAspspProfileBankSetting pis = new NewPisAspspProfileBankSetting(setting.getSupportedPaymentTypeAndProductMatrix().entrySet().stream().collect(Collectors.toMap(e -> PaymentType.valueOf((String)((String)e.getKey())), e -> new ArrayList((Collection)e.getValue()))), setting.getTransactionLifetime(), setting.getNotConfirmedPaymentExpirationPeriodMs(), setting.isPaymentCancellationAuthorizationMandated(), pisRedirectLinkToOnlineBanking);
        PiisAspspProfileBankSetting piis = new PiisAspspProfileBankSetting(setting.isPiisConsentSupported());
        CommonAspspProfileBankSetting common = new CommonAspspProfileBankSetting(setting.getScaApproaches(), setting.getScaRedirectFlow(), setting.getStartAuthorisationMode(), setting.isTppSignatureRequired(), setting.isPsuInInitialRequestMandated(), setting.getRedirectUrlExpirationTimeMs(), setting.getAuthorisationExpirationTimeMs(), setting.isForceXs2aBaseUrl(), setting.getXs2aBaseUrl(), setting.getSupportedAccountReferenceFields(), setting.getMulticurrencyAccountLevel(), setting.isCombinedServiceIndicator(), setting.isSigningBasketSupported());
        NewProfileConfiguration result = new NewProfileConfiguration();
        result.setSetting(new NewBankProfileSetting(ais, pis, piis, common));
        return result;
    }
}

