/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.config;

import de.adorsys.psd2.aspsp.profile.config.ProfileConfiguration;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

@Configuration
public class BankProfileReaderConfiguration
implements ResourceLoaderAware {
    private static final Logger log = LoggerFactory.getLogger(BankProfileReaderConfiguration.class);
    private static final String DEFAULT_BANK_PROFILE = "classpath:bank_profile.yml";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String FILE_PREFIX = "file:";
    @Value(value="${bank_profile.path:}")
    private String customBankProfile;
    private ResourceLoader resourceLoader;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Bean
    public ProfileConfiguration profileConfiguration() {
        Representer representer = new Representer();
        representer.getPropertyUtils().setSkipMissingProperties(true);
        return (ProfileConfiguration)new Yaml(representer, this.getDumperOptions()).loadAs(this.loadProfile(), ProfileConfiguration.class);
    }

    private DumperOptions getDumperOptions() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return options;
    }

    private InputStream loadProfile() {
        Resource resource = this.resourceLoader.getResource(this.resolveBankProfile());
        try {
            return resource.getInputStream();
        }
        catch (IOException e) {
            log.error("PSD2 api file is not found", (Throwable)e);
            throw new IllegalArgumentException("PSD2 api file is not found");
        }
    }

    private String resolveBankProfile() {
        if (StringUtils.isBlank((CharSequence)this.customBankProfile)) {
            return DEFAULT_BANK_PROFILE;
        }
        if (this.customBankProfile.startsWith(CLASSPATH_PREFIX) || this.customBankProfile.startsWith(FILE_PREFIX)) {
            return this.customBankProfile;
        }
        return FILE_PREFIX + this.customBankProfile;
    }
}

