/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.config;

import de.adorsys.psd2.aspsp.profile.config.BankProfileSetting;
import de.adorsys.psd2.aspsp.profile.domain.SupportedAccountReferenceField;
import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.profile.ScaRedirectFlow;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.InitializingBean;

public class ProfileConfiguration
implements InitializingBean {
    private BankProfileSetting setting;

    public void afterPropertiesSet() {
        this.setDefaultScaApproach(ScaApproach.REDIRECT);
        this.setDefaultBookingStatus(BookingStatus.BOOKED);
        this.setAvailableAccountReferenceField(SupportedAccountReferenceField.IBAN);
        this.setDefaultScaRedirectFlow();
    }

    private void setDefaultScaRedirectFlow() {
        if (Objects.isNull(this.setting.getScaRedirectFlow())) {
            this.setting.setScaRedirectFlow(ScaRedirectFlow.REDIRECT);
        }
    }

    private void setDefaultScaApproach(ScaApproach scaApproach) {
        if (CollectionUtils.isEmpty(this.setting.getScaApproaches())) {
            this.setting.setScaApproaches(Collections.singletonList(scaApproach));
        }
    }

    private void setAvailableAccountReferenceField(SupportedAccountReferenceField defaultSupportedAccountReferenceField) {
        List<SupportedAccountReferenceField> supportedAccountReferenceFields = this.setting.getSupportedAccountReferenceFields();
        if (!supportedAccountReferenceFields.contains(defaultSupportedAccountReferenceField)) {
            supportedAccountReferenceFields.add(defaultSupportedAccountReferenceField);
        }
    }

    private void setDefaultBookingStatus(BookingStatus necessaryStatus) {
        List<BookingStatus> availableBookingStatuses = this.setting.getAvailableBookingStatuses();
        if (!availableBookingStatuses.contains(necessaryStatus)) {
            availableBookingStatuses.add(necessaryStatus);
        }
    }

    public BankProfileSetting getSetting() {
        return this.setting;
    }

    public void setSetting(BankProfileSetting setting) {
        this.setting = setting;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfileConfiguration)) {
            return false;
        }
        ProfileConfiguration other = (ProfileConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BankProfileSetting this$setting = this.getSetting();
        BankProfileSetting other$setting = other.getSetting();
        return !(this$setting == null ? other$setting != null : !((Object)this$setting).equals(other$setting));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProfileConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BankProfileSetting $setting = this.getSetting();
        result = result * 59 + ($setting == null ? 43 : ((Object)$setting).hashCode());
        return result;
    }

    public String toString() {
        return "ProfileConfiguration(setting=" + this.getSetting() + ")";
    }
}

