/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.service;

import de.adorsys.psd2.aspsp.profile.config.BankProfileSetting;
import de.adorsys.psd2.aspsp.profile.config.ProfileConfiguration;
import de.adorsys.psd2.aspsp.profile.domain.AspspSettings;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileUpdateService;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import java.beans.ConstructorProperties;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class AspspProfileUpdateServiceImpl
implements AspspProfileUpdateService {
    private final ProfileConfiguration profileConfiguration;

    @Override
    public void updateScaApproaches(List<ScaApproach> scaApproaches) {
        this.profileConfiguration.getSetting().setScaApproaches(scaApproaches);
    }

    @Override
    public void updateAspspSettings(@NotNull AspspSettings aspspSettings) {
        BankProfileSetting setting = this.profileConfiguration.getSetting();
        setting.setFrequencyPerDay(aspspSettings.getFrequencyPerDay());
        setting.setCombinedServiceIndicator(aspspSettings.isCombinedServiceIndicator());
        setting.setTppSignatureRequired(aspspSettings.isTppSignatureRequired());
        setting.setPisRedirectUrlToAspsp(aspspSettings.getPisRedirectUrlToAspsp());
        setting.setAisRedirectUrlToAspsp(aspspSettings.getAisRedirectUrlToAspsp());
        setting.setMulticurrencyAccountLevel(aspspSettings.getMulticurrencyAccountLevel());
        setting.setBankOfferedConsentSupport(aspspSettings.isBankOfferedConsentSupport());
        setting.setAvailableBookingStatuses(aspspSettings.getAvailableBookingStatuses());
        setting.setSupportedAccountReferenceFields(aspspSettings.getSupportedAccountReferenceFields());
        setting.setConsentLifetime(aspspSettings.getConsentLifetime());
        setting.setTransactionLifetime(aspspSettings.getTransactionLifetime());
        setting.setAllPsd2Support(aspspSettings.isAllPsd2Support());
        setting.setTransactionsWithoutBalancesSupported(aspspSettings.isTransactionsWithoutBalancesSupported());
        setting.setSigningBasketSupported(aspspSettings.isSigningBasketSupported());
        setting.setPaymentCancellationAuthorizationMandated(aspspSettings.isPaymentCancellationAuthorizationMandated());
        setting.setPiisConsentSupported(aspspSettings.isPiisConsentSupported());
        setting.setDeltaReportSupported(aspspSettings.isDeltaReportSupported());
        setting.setRedirectUrlExpirationTimeMs(aspspSettings.getRedirectUrlExpirationTimeMs());
        setting.setPisPaymentCancellationRedirectUrlToAspsp(aspspSettings.getPisPaymentCancellationRedirectUrlToAspsp());
        setting.setNotConfirmedConsentExpirationPeriodMs(aspspSettings.getNotConfirmedConsentExpirationPeriodMs());
        setting.setNotConfirmedPaymentExpirationPeriodMs(aspspSettings.getNotConfirmedPaymentExpirationPeriodMs());
        setting.setSupportedPaymentTypeAndProductMatrix(aspspSettings.getSupportedPaymentTypeAndProductMatrix());
        setting.setPaymentCancellationRedirectUrlExpirationTimeMs(aspspSettings.getPaymentCancellationRedirectUrlExpirationTimeMs());
        setting.setAvailableAccountsConsentSupported(aspspSettings.isAvailableAccountsConsentSupported());
        setting.setScaByOneTimeAvailableAccountsConsentRequired(aspspSettings.isScaByOneTimeAvailableAccountsConsentRequired());
        setting.setPsuInInitialRequestMandated(aspspSettings.isPsuInInitialRequestMandated());
        setting.setForceXs2aBaseUrl(aspspSettings.isForceXs2aBaseUrl());
        setting.setXs2aBaseUrl(aspspSettings.getXs2aBaseUrl());
    }

    @ConstructorProperties(value={"profileConfiguration"})
    public AspspProfileUpdateServiceImpl(ProfileConfiguration profileConfiguration) {
        this.profileConfiguration = profileConfiguration;
    }
}

