/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.config;

import de.adorsys.psd2.aspsp.profile.config.BankProfileSetting;
import de.adorsys.psd2.aspsp.profile.config.ProfileConfiguration;
import de.adorsys.psd2.aspsp.profile.exception.AspspProfileConfigurationNotFoundException;
import de.adorsys.psd2.aspsp.profile.exception.InstanceIdIsMandatoryHeaderException;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;

public class ProfileConfigurations
implements InitializingBean {
    private boolean multitenancyEnabled;
    private ProfileConfiguration singleConfiguration;
    private Map<String, ProfileConfiguration> instanceConfigurations;

    public void afterPropertiesSet() {
        this.setDefaultProperties();
    }

    public void setDefaultProperties() {
        this.singleConfiguration.setDefaultProperties();
        this.instanceConfigurations.values().forEach(ProfileConfiguration::setDefaultProperties);
    }

    public BankProfileSetting getSetting(String instanceId) {
        if (this.multitenancyEnabled) {
            if (StringUtils.isBlank((CharSequence)instanceId)) {
                throw new InstanceIdIsMandatoryHeaderException();
            }
            if (!this.instanceConfigurations.containsKey(instanceId.toLowerCase())) {
                throw new AspspProfileConfigurationNotFoundException(instanceId);
            }
            return this.instanceConfigurations.get(instanceId.toLowerCase()).getSetting();
        }
        return this.singleConfiguration.getSetting();
    }

    public void updateSettings(ProfileConfigurations newProfileConfiguration) {
        this.singleConfiguration.setSetting(newProfileConfiguration.getSingleConfiguration().getSetting());
        this.instanceConfigurations.clear();
        this.instanceConfigurations.putAll(newProfileConfiguration.getInstanceConfigurations());
    }

    public boolean isMultitenancyEnabled() {
        return this.multitenancyEnabled;
    }

    public ProfileConfiguration getSingleConfiguration() {
        return this.singleConfiguration;
    }

    public Map<String, ProfileConfiguration> getInstanceConfigurations() {
        return this.instanceConfigurations;
    }

    public void setMultitenancyEnabled(boolean multitenancyEnabled) {
        this.multitenancyEnabled = multitenancyEnabled;
    }

    public void setSingleConfiguration(ProfileConfiguration singleConfiguration) {
        this.singleConfiguration = singleConfiguration;
    }

    public void setInstanceConfigurations(Map<String, ProfileConfiguration> instanceConfigurations) {
        this.instanceConfigurations = instanceConfigurations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfileConfigurations)) {
            return false;
        }
        ProfileConfigurations other = (ProfileConfigurations)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMultitenancyEnabled() != other.isMultitenancyEnabled()) {
            return false;
        }
        ProfileConfiguration this$singleConfiguration = this.getSingleConfiguration();
        ProfileConfiguration other$singleConfiguration = other.getSingleConfiguration();
        if (this$singleConfiguration == null ? other$singleConfiguration != null : !((Object)this$singleConfiguration).equals(other$singleConfiguration)) {
            return false;
        }
        Map<String, ProfileConfiguration> this$instanceConfigurations = this.getInstanceConfigurations();
        Map<String, ProfileConfiguration> other$instanceConfigurations = other.getInstanceConfigurations();
        return !(this$instanceConfigurations == null ? other$instanceConfigurations != null : !((Object)this$instanceConfigurations).equals(other$instanceConfigurations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProfileConfigurations;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMultitenancyEnabled() ? 79 : 97);
        ProfileConfiguration $singleConfiguration = this.getSingleConfiguration();
        result = result * 59 + ($singleConfiguration == null ? 43 : ((Object)$singleConfiguration).hashCode());
        Map<String, ProfileConfiguration> $instanceConfigurations = this.getInstanceConfigurations();
        result = result * 59 + ($instanceConfigurations == null ? 43 : ((Object)$instanceConfigurations).hashCode());
        return result;
    }

    public String toString() {
        return "ProfileConfigurations(multitenancyEnabled=" + this.isMultitenancyEnabled() + ", singleConfiguration=" + this.getSingleConfiguration() + ", instanceConfigurations=" + this.getInstanceConfigurations() + ")";
    }

    @ConstructorProperties(value={"multitenancyEnabled", "singleConfiguration", "instanceConfigurations"})
    public ProfileConfigurations(boolean multitenancyEnabled, ProfileConfiguration singleConfiguration, Map<String, ProfileConfiguration> instanceConfigurations) {
        this.multitenancyEnabled = multitenancyEnabled;
        this.singleConfiguration = singleConfiguration;
        this.instanceConfigurations = instanceConfigurations;
    }
}

