/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.service;

import de.adorsys.psd2.aspsp.profile.domain.SupportedAccountReferenceField;
import de.adorsys.psd2.aspsp.profile.domain.migration.NewProfileConfiguration;
import de.adorsys.psd2.aspsp.profile.domain.migration.OldProfileConfiguration;
import de.adorsys.psd2.aspsp.profile.mapper.NewProfileConfigurationMapper;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileConvertService;
import de.adorsys.psd2.xs2a.core.ais.BookingStatus;
import de.adorsys.psd2.xs2a.core.profile.NotificationSupportedMode;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

@Service
public class AspspProfileConvertServiceImpl
implements AspspProfileConvertService {
    private NewProfileConfigurationMapper newProfileConfigurationMapper;

    public String convertProfile(OldProfileConfiguration profile) {
        NewProfileConfiguration newProfileConfiguration = this.newProfileConfigurationMapper.mapToNewProfileConfiguration(profile);
        Yaml yaml = new Yaml(this.getYamlRepresenter(), this.getYamlDumperOptions());
        return yaml.dumpAsMap((Object)newProfileConfiguration);
    }

    @NotNull
    private Representer getYamlRepresenter() {
        Representer representer = new Representer();
        representer.addClassTag(BookingStatus.class, Tag.STR);
        representer.addClassTag(ScaApproach.class, Tag.STR);
        representer.addClassTag(SupportedAccountReferenceField.class, Tag.STR);
        representer.addClassTag(NotificationSupportedMode.class, Tag.STR);
        return representer;
    }

    @NotNull
    private DumperOptions getYamlDumperOptions() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        options.setExplicitStart(true);
        return options;
    }

    @ConstructorProperties(value={"newProfileConfigurationMapper"})
    public AspspProfileConvertServiceImpl(NewProfileConfigurationMapper newProfileConfigurationMapper) {
        this.newProfileConfigurationMapper = newProfileConfigurationMapper;
    }
}

