/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.service;

import de.adorsys.psd2.aspsp.profile.config.ProfileConfiguration;
import de.adorsys.psd2.aspsp.profile.domain.BookingStatus;
import de.adorsys.psd2.aspsp.profile.domain.MulticurrencyAccountLevel;
import de.adorsys.psd2.aspsp.profile.domain.SupportedAccountReferenceField;
import de.adorsys.psd2.aspsp.profile.service.AspspProfileUpdateService;
import de.adorsys.psd2.xs2a.core.profile.PaymentProduct;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class AspspProfileUpdateServiceImpl
implements AspspProfileUpdateService {
    private final ProfileConfiguration profileConfiguration;

    @Override
    public void updateFrequencyPerDay(int frequencyPerDay) {
        this.profileConfiguration.setFrequencyPerDay(frequencyPerDay);
    }

    @Override
    public void updateCombinedServiceIndicator(boolean combinedServiceIndicator) {
        this.profileConfiguration.setCombinedServiceIndicator(combinedServiceIndicator);
    }

    @Override
    public void updateBankOfferedConsentSupport(boolean bankOfferedConsentSupport) {
        this.profileConfiguration.setBankOfferedConsentSupport(bankOfferedConsentSupport);
    }

    @Override
    public void updateAvailablePaymentProducts(List<PaymentProduct> availablePaymentProducts) {
        this.profileConfiguration.setAvailablePaymentProducts(availablePaymentProducts);
    }

    @Override
    public void updateAvailablePaymentTypes(List<PaymentType> availablePaymentTypes) {
        this.profileConfiguration.setAvailablePaymentTypes(availablePaymentTypes);
    }

    @Override
    public void updateScaApproach(ScaApproach scaApproach) {
        this.profileConfiguration.setScaApproach(scaApproach);
    }

    @Override
    public void updateTppSignatureRequired(boolean tppSignatureRequired) {
        this.profileConfiguration.setTppSignatureRequired(tppSignatureRequired);
    }

    @Override
    public void updatePisRedirectUrlToAspsp(String redirectUrlToAspsp) {
        this.profileConfiguration.setPisRedirectUrlToAspsp(redirectUrlToAspsp);
    }

    @Override
    public void updateAisRedirectUrlToAspsp(String redirectUrlToAspsp) {
        this.profileConfiguration.setAisRedirectUrlToAspsp(redirectUrlToAspsp);
    }

    @Override
    public void updateMulticurrencyAccountLevel(MulticurrencyAccountLevel multicurrencyAccountLevel) {
        this.profileConfiguration.setMulticurrencyAccountLevel(multicurrencyAccountLevel);
    }

    @Override
    public void updateAvailableBookingStatuses(List<BookingStatus> availableBookingStatuses) {
        if (!availableBookingStatuses.contains(BookingStatus.BOOKED)) {
            availableBookingStatuses.add(BookingStatus.BOOKED);
        }
        this.profileConfiguration.setAvailableBookingStatuses(availableBookingStatuses);
    }

    @Override
    public void updateSupportedAccountReferenceFields(List<SupportedAccountReferenceField> fields) {
        if (!fields.contains(SupportedAccountReferenceField.IBAN)) {
            fields.add(SupportedAccountReferenceField.IBAN);
        }
        this.profileConfiguration.setSupportedAccountReferenceFields(fields);
    }

    @Override
    public void updateConsentLifetime(int consentLifetime) {
        this.profileConfiguration.setConsentLifetime(consentLifetime);
    }

    @Override
    public void updateTransactionLifetime(int transactionLifetime) {
        this.profileConfiguration.setTransactionLifetime(transactionLifetime);
    }

    @Override
    public void updateAllPsd2Support(boolean allPsd2Support) {
        this.profileConfiguration.setAllPsd2Support(allPsd2Support);
    }

    @Override
    public void updateTransactionsWithoutBalancesSupported(boolean transactionsWithoutBalancesSupported) {
        this.profileConfiguration.setTransactionsWithoutBalancesSupported(transactionsWithoutBalancesSupported);
    }

    @Override
    public void updateSigningBasketSupported(boolean signingBasketSupported) {
        this.profileConfiguration.setSigningBasketSupported(signingBasketSupported);
    }

    @Override
    public void updatePaymentCancellationAuthorizationMandated(boolean paymentCancellationAuthorizationMandated) {
        this.profileConfiguration.setPaymentCancellationAuthorizationMandated(paymentCancellationAuthorizationMandated);
    }

    @ConstructorProperties(value={"profileConfiguration"})
    public AspspProfileUpdateServiceImpl(ProfileConfiguration profileConfiguration) {
        this.profileConfiguration = profileConfiguration;
    }
}

