/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.config;

import de.adorsys.psd2.aspsp.profile.domain.BookingStatus;
import de.adorsys.psd2.aspsp.profile.domain.MulticurrencyAccountLevel;
import de.adorsys.psd2.aspsp.profile.domain.SupportedAccountReferenceField;
import de.adorsys.psd2.xs2a.core.profile.PaymentProduct;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:bank_profile.yml", "file:${bank_profile.path}"}, ignoreResourceNotFound=true)
@ConfigurationProperties
public class ProfileConfiguration {
    private int frequencyPerDay;
    private boolean combinedServiceIndicator;
    private List<PaymentProduct> availablePaymentProducts = new ArrayList<PaymentProduct>();
    private List<PaymentType> availablePaymentTypes = new ArrayList<PaymentType>();
    private ScaApproach scaApproach;
    private boolean tppSignatureRequired;
    private String pisRedirectUrlToAspsp;
    private String aisRedirectUrlToAspsp;
    private MulticurrencyAccountLevel multicurrencyAccountLevel;
    private boolean bankOfferedConsentSupport;
    private List<BookingStatus> availableBookingStatuses = new ArrayList<BookingStatus>();
    private List<SupportedAccountReferenceField> supportedAccountReferenceFields = new ArrayList<SupportedAccountReferenceField>();
    private int consentLifetime;
    private int transactionLifetime;
    private boolean allPsd2Support;
    private boolean transactionsWithoutBalancesSupported;
    private boolean signingBasketSupported;
    private boolean paymentCancellationAuthorizationMandated;

    @PostConstruct
    private void addDefaultValues() {
        this.setDefaultPaymentType(PaymentType.SINGLE);
        this.setDefaultBookingStatus(BookingStatus.BOOKED);
        this.setAvailableAccountReferenceField(SupportedAccountReferenceField.IBAN);
    }

    private void setAvailableAccountReferenceField(SupportedAccountReferenceField defaultSupportedAccountReferenceField) {
        if (!this.supportedAccountReferenceFields.contains(defaultSupportedAccountReferenceField)) {
            this.supportedAccountReferenceFields.add(defaultSupportedAccountReferenceField);
        }
    }

    private void setDefaultPaymentType(PaymentType necessaryType) {
        if (!this.availablePaymentTypes.contains(necessaryType)) {
            this.availablePaymentTypes.add(necessaryType);
        }
    }

    private void setDefaultBookingStatus(BookingStatus necessaryStatus) {
        if (!this.availableBookingStatuses.contains(necessaryStatus)) {
            this.availableBookingStatuses.add(necessaryStatus);
        }
    }

    public int getFrequencyPerDay() {
        return this.frequencyPerDay;
    }

    public boolean isCombinedServiceIndicator() {
        return this.combinedServiceIndicator;
    }

    public List<PaymentProduct> getAvailablePaymentProducts() {
        return this.availablePaymentProducts;
    }

    public List<PaymentType> getAvailablePaymentTypes() {
        return this.availablePaymentTypes;
    }

    public ScaApproach getScaApproach() {
        return this.scaApproach;
    }

    public boolean isTppSignatureRequired() {
        return this.tppSignatureRequired;
    }

    public String getPisRedirectUrlToAspsp() {
        return this.pisRedirectUrlToAspsp;
    }

    public String getAisRedirectUrlToAspsp() {
        return this.aisRedirectUrlToAspsp;
    }

    public MulticurrencyAccountLevel getMulticurrencyAccountLevel() {
        return this.multicurrencyAccountLevel;
    }

    public boolean isBankOfferedConsentSupport() {
        return this.bankOfferedConsentSupport;
    }

    public List<BookingStatus> getAvailableBookingStatuses() {
        return this.availableBookingStatuses;
    }

    public List<SupportedAccountReferenceField> getSupportedAccountReferenceFields() {
        return this.supportedAccountReferenceFields;
    }

    public int getConsentLifetime() {
        return this.consentLifetime;
    }

    public int getTransactionLifetime() {
        return this.transactionLifetime;
    }

    public boolean isAllPsd2Support() {
        return this.allPsd2Support;
    }

    public boolean isTransactionsWithoutBalancesSupported() {
        return this.transactionsWithoutBalancesSupported;
    }

    public boolean isSigningBasketSupported() {
        return this.signingBasketSupported;
    }

    public boolean isPaymentCancellationAuthorizationMandated() {
        return this.paymentCancellationAuthorizationMandated;
    }

    public void setFrequencyPerDay(int frequencyPerDay) {
        this.frequencyPerDay = frequencyPerDay;
    }

    public void setCombinedServiceIndicator(boolean combinedServiceIndicator) {
        this.combinedServiceIndicator = combinedServiceIndicator;
    }

    public void setAvailablePaymentProducts(List<PaymentProduct> availablePaymentProducts) {
        this.availablePaymentProducts = availablePaymentProducts;
    }

    public void setAvailablePaymentTypes(List<PaymentType> availablePaymentTypes) {
        this.availablePaymentTypes = availablePaymentTypes;
    }

    public void setScaApproach(ScaApproach scaApproach) {
        this.scaApproach = scaApproach;
    }

    public void setTppSignatureRequired(boolean tppSignatureRequired) {
        this.tppSignatureRequired = tppSignatureRequired;
    }

    public void setPisRedirectUrlToAspsp(String pisRedirectUrlToAspsp) {
        this.pisRedirectUrlToAspsp = pisRedirectUrlToAspsp;
    }

    public void setAisRedirectUrlToAspsp(String aisRedirectUrlToAspsp) {
        this.aisRedirectUrlToAspsp = aisRedirectUrlToAspsp;
    }

    public void setMulticurrencyAccountLevel(MulticurrencyAccountLevel multicurrencyAccountLevel) {
        this.multicurrencyAccountLevel = multicurrencyAccountLevel;
    }

    public void setBankOfferedConsentSupport(boolean bankOfferedConsentSupport) {
        this.bankOfferedConsentSupport = bankOfferedConsentSupport;
    }

    public void setAvailableBookingStatuses(List<BookingStatus> availableBookingStatuses) {
        this.availableBookingStatuses = availableBookingStatuses;
    }

    public void setSupportedAccountReferenceFields(List<SupportedAccountReferenceField> supportedAccountReferenceFields) {
        this.supportedAccountReferenceFields = supportedAccountReferenceFields;
    }

    public void setConsentLifetime(int consentLifetime) {
        this.consentLifetime = consentLifetime;
    }

    public void setTransactionLifetime(int transactionLifetime) {
        this.transactionLifetime = transactionLifetime;
    }

    public void setAllPsd2Support(boolean allPsd2Support) {
        this.allPsd2Support = allPsd2Support;
    }

    public void setTransactionsWithoutBalancesSupported(boolean transactionsWithoutBalancesSupported) {
        this.transactionsWithoutBalancesSupported = transactionsWithoutBalancesSupported;
    }

    public void setSigningBasketSupported(boolean signingBasketSupported) {
        this.signingBasketSupported = signingBasketSupported;
    }

    public void setPaymentCancellationAuthorizationMandated(boolean paymentCancellationAuthorizationMandated) {
        this.paymentCancellationAuthorizationMandated = paymentCancellationAuthorizationMandated;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProfileConfiguration)) {
            return false;
        }
        ProfileConfiguration other = (ProfileConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFrequencyPerDay() != other.getFrequencyPerDay()) {
            return false;
        }
        if (this.isCombinedServiceIndicator() != other.isCombinedServiceIndicator()) {
            return false;
        }
        List<PaymentProduct> this$availablePaymentProducts = this.getAvailablePaymentProducts();
        List<PaymentProduct> other$availablePaymentProducts = other.getAvailablePaymentProducts();
        if (this$availablePaymentProducts == null ? other$availablePaymentProducts != null : !((Object)this$availablePaymentProducts).equals(other$availablePaymentProducts)) {
            return false;
        }
        List<PaymentType> this$availablePaymentTypes = this.getAvailablePaymentTypes();
        List<PaymentType> other$availablePaymentTypes = other.getAvailablePaymentTypes();
        if (this$availablePaymentTypes == null ? other$availablePaymentTypes != null : !((Object)this$availablePaymentTypes).equals(other$availablePaymentTypes)) {
            return false;
        }
        ScaApproach this$scaApproach = this.getScaApproach();
        ScaApproach other$scaApproach = other.getScaApproach();
        if (this$scaApproach == null ? other$scaApproach != null : !this$scaApproach.equals(other$scaApproach)) {
            return false;
        }
        if (this.isTppSignatureRequired() != other.isTppSignatureRequired()) {
            return false;
        }
        String this$pisRedirectUrlToAspsp = this.getPisRedirectUrlToAspsp();
        String other$pisRedirectUrlToAspsp = other.getPisRedirectUrlToAspsp();
        if (this$pisRedirectUrlToAspsp == null ? other$pisRedirectUrlToAspsp != null : !this$pisRedirectUrlToAspsp.equals(other$pisRedirectUrlToAspsp)) {
            return false;
        }
        String this$aisRedirectUrlToAspsp = this.getAisRedirectUrlToAspsp();
        String other$aisRedirectUrlToAspsp = other.getAisRedirectUrlToAspsp();
        if (this$aisRedirectUrlToAspsp == null ? other$aisRedirectUrlToAspsp != null : !this$aisRedirectUrlToAspsp.equals(other$aisRedirectUrlToAspsp)) {
            return false;
        }
        MulticurrencyAccountLevel this$multicurrencyAccountLevel = this.getMulticurrencyAccountLevel();
        MulticurrencyAccountLevel other$multicurrencyAccountLevel = other.getMulticurrencyAccountLevel();
        if (this$multicurrencyAccountLevel == null ? other$multicurrencyAccountLevel != null : !this$multicurrencyAccountLevel.equals(other$multicurrencyAccountLevel)) {
            return false;
        }
        if (this.isBankOfferedConsentSupport() != other.isBankOfferedConsentSupport()) {
            return false;
        }
        List<BookingStatus> this$availableBookingStatuses = this.getAvailableBookingStatuses();
        List<BookingStatus> other$availableBookingStatuses = other.getAvailableBookingStatuses();
        if (this$availableBookingStatuses == null ? other$availableBookingStatuses != null : !((Object)this$availableBookingStatuses).equals(other$availableBookingStatuses)) {
            return false;
        }
        List<SupportedAccountReferenceField> this$supportedAccountReferenceFields = this.getSupportedAccountReferenceFields();
        List<SupportedAccountReferenceField> other$supportedAccountReferenceFields = other.getSupportedAccountReferenceFields();
        if (this$supportedAccountReferenceFields == null ? other$supportedAccountReferenceFields != null : !((Object)this$supportedAccountReferenceFields).equals(other$supportedAccountReferenceFields)) {
            return false;
        }
        if (this.getConsentLifetime() != other.getConsentLifetime()) {
            return false;
        }
        if (this.getTransactionLifetime() != other.getTransactionLifetime()) {
            return false;
        }
        if (this.isAllPsd2Support() != other.isAllPsd2Support()) {
            return false;
        }
        if (this.isTransactionsWithoutBalancesSupported() != other.isTransactionsWithoutBalancesSupported()) {
            return false;
        }
        if (this.isSigningBasketSupported() != other.isSigningBasketSupported()) {
            return false;
        }
        return this.isPaymentCancellationAuthorizationMandated() == other.isPaymentCancellationAuthorizationMandated();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProfileConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFrequencyPerDay();
        result = result * 59 + (this.isCombinedServiceIndicator() ? 79 : 97);
        List<PaymentProduct> $availablePaymentProducts = this.getAvailablePaymentProducts();
        result = result * 59 + ($availablePaymentProducts == null ? 43 : ((Object)$availablePaymentProducts).hashCode());
        List<PaymentType> $availablePaymentTypes = this.getAvailablePaymentTypes();
        result = result * 59 + ($availablePaymentTypes == null ? 43 : ((Object)$availablePaymentTypes).hashCode());
        ScaApproach $scaApproach = this.getScaApproach();
        result = result * 59 + ($scaApproach == null ? 43 : $scaApproach.hashCode());
        result = result * 59 + (this.isTppSignatureRequired() ? 79 : 97);
        String $pisRedirectUrlToAspsp = this.getPisRedirectUrlToAspsp();
        result = result * 59 + ($pisRedirectUrlToAspsp == null ? 43 : $pisRedirectUrlToAspsp.hashCode());
        String $aisRedirectUrlToAspsp = this.getAisRedirectUrlToAspsp();
        result = result * 59 + ($aisRedirectUrlToAspsp == null ? 43 : $aisRedirectUrlToAspsp.hashCode());
        MulticurrencyAccountLevel $multicurrencyAccountLevel = this.getMulticurrencyAccountLevel();
        result = result * 59 + ($multicurrencyAccountLevel == null ? 43 : $multicurrencyAccountLevel.hashCode());
        result = result * 59 + (this.isBankOfferedConsentSupport() ? 79 : 97);
        List<BookingStatus> $availableBookingStatuses = this.getAvailableBookingStatuses();
        result = result * 59 + ($availableBookingStatuses == null ? 43 : ((Object)$availableBookingStatuses).hashCode());
        List<SupportedAccountReferenceField> $supportedAccountReferenceFields = this.getSupportedAccountReferenceFields();
        result = result * 59 + ($supportedAccountReferenceFields == null ? 43 : ((Object)$supportedAccountReferenceFields).hashCode());
        result = result * 59 + this.getConsentLifetime();
        result = result * 59 + this.getTransactionLifetime();
        result = result * 59 + (this.isAllPsd2Support() ? 79 : 97);
        result = result * 59 + (this.isTransactionsWithoutBalancesSupported() ? 79 : 97);
        result = result * 59 + (this.isSigningBasketSupported() ? 79 : 97);
        result = result * 59 + (this.isPaymentCancellationAuthorizationMandated() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "ProfileConfiguration(frequencyPerDay=" + this.getFrequencyPerDay() + ", combinedServiceIndicator=" + this.isCombinedServiceIndicator() + ", availablePaymentProducts=" + this.getAvailablePaymentProducts() + ", availablePaymentTypes=" + this.getAvailablePaymentTypes() + ", scaApproach=" + this.getScaApproach() + ", tppSignatureRequired=" + this.isTppSignatureRequired() + ", pisRedirectUrlToAspsp=" + this.getPisRedirectUrlToAspsp() + ", aisRedirectUrlToAspsp=" + this.getAisRedirectUrlToAspsp() + ", multicurrencyAccountLevel=" + this.getMulticurrencyAccountLevel() + ", bankOfferedConsentSupport=" + this.isBankOfferedConsentSupport() + ", availableBookingStatuses=" + this.getAvailableBookingStatuses() + ", supportedAccountReferenceFields=" + this.getSupportedAccountReferenceFields() + ", consentLifetime=" + this.getConsentLifetime() + ", transactionLifetime=" + this.getTransactionLifetime() + ", allPsd2Support=" + this.isAllPsd2Support() + ", transactionsWithoutBalancesSupported=" + this.isTransactionsWithoutBalancesSupported() + ", signingBasketSupported=" + this.isSigningBasketSupported() + ", paymentCancellationAuthorizationMandated=" + this.isPaymentCancellationAuthorizationMandated() + ")";
    }
}

