/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.domain.ais;

import java.beans.ConstructorProperties;

public final class ConsentTypeSetting {
    private final boolean bankOfferedConsentSupported;
    private final boolean globalConsentSupported;
    private final boolean availableAccountsConsentSupported;
    private final int accountAccessFrequencyPerDay;
    private final long notConfirmedConsentExpirationTimeMs;
    private final int maxConsentValidityDays;

    @ConstructorProperties(value={"bankOfferedConsentSupported", "globalConsentSupported", "availableAccountsConsentSupported", "accountAccessFrequencyPerDay", "notConfirmedConsentExpirationTimeMs", "maxConsentValidityDays"})
    public ConsentTypeSetting(boolean bankOfferedConsentSupported, boolean globalConsentSupported, boolean availableAccountsConsentSupported, int accountAccessFrequencyPerDay, long notConfirmedConsentExpirationTimeMs, int maxConsentValidityDays) {
        this.bankOfferedConsentSupported = bankOfferedConsentSupported;
        this.globalConsentSupported = globalConsentSupported;
        this.availableAccountsConsentSupported = availableAccountsConsentSupported;
        this.accountAccessFrequencyPerDay = accountAccessFrequencyPerDay;
        this.notConfirmedConsentExpirationTimeMs = notConfirmedConsentExpirationTimeMs;
        this.maxConsentValidityDays = maxConsentValidityDays;
    }

    public boolean isBankOfferedConsentSupported() {
        return this.bankOfferedConsentSupported;
    }

    public boolean isGlobalConsentSupported() {
        return this.globalConsentSupported;
    }

    public boolean isAvailableAccountsConsentSupported() {
        return this.availableAccountsConsentSupported;
    }

    public int getAccountAccessFrequencyPerDay() {
        return this.accountAccessFrequencyPerDay;
    }

    public long getNotConfirmedConsentExpirationTimeMs() {
        return this.notConfirmedConsentExpirationTimeMs;
    }

    public int getMaxConsentValidityDays() {
        return this.maxConsentValidityDays;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsentTypeSetting)) {
            return false;
        }
        ConsentTypeSetting other = (ConsentTypeSetting)o;
        if (this.isBankOfferedConsentSupported() != other.isBankOfferedConsentSupported()) {
            return false;
        }
        if (this.isGlobalConsentSupported() != other.isGlobalConsentSupported()) {
            return false;
        }
        if (this.isAvailableAccountsConsentSupported() != other.isAvailableAccountsConsentSupported()) {
            return false;
        }
        if (this.getAccountAccessFrequencyPerDay() != other.getAccountAccessFrequencyPerDay()) {
            return false;
        }
        if (this.getNotConfirmedConsentExpirationTimeMs() != other.getNotConfirmedConsentExpirationTimeMs()) {
            return false;
        }
        return this.getMaxConsentValidityDays() == other.getMaxConsentValidityDays();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBankOfferedConsentSupported() ? 79 : 97);
        result = result * 59 + (this.isGlobalConsentSupported() ? 79 : 97);
        result = result * 59 + (this.isAvailableAccountsConsentSupported() ? 79 : 97);
        result = result * 59 + this.getAccountAccessFrequencyPerDay();
        long $notConfirmedConsentExpirationTimeMs = this.getNotConfirmedConsentExpirationTimeMs();
        result = result * 59 + (int)($notConfirmedConsentExpirationTimeMs >>> 32 ^ $notConfirmedConsentExpirationTimeMs);
        result = result * 59 + this.getMaxConsentValidityDays();
        return result;
    }

    public String toString() {
        return "ConsentTypeSetting(bankOfferedConsentSupported=" + this.isBankOfferedConsentSupported() + ", globalConsentSupported=" + this.isGlobalConsentSupported() + ", availableAccountsConsentSupported=" + this.isAvailableAccountsConsentSupported() + ", accountAccessFrequencyPerDay=" + this.getAccountAccessFrequencyPerDay() + ", notConfirmedConsentExpirationTimeMs=" + this.getNotConfirmedConsentExpirationTimeMs() + ", maxConsentValidityDays=" + this.getMaxConsentValidityDays() + ")";
    }
}

