/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.aspsp.profile.domain;

import io.swagger.annotations.ApiModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@ApiModel(description="PaymentType", value="Payment types of ASPSP")
public enum PaymentType {
    BULK("bulk"),
    PERIODIC("periodic"),
    FUTURE_DATED("delayed"),
    SINGLE("single");

    private static final Map<String, PaymentType> container;
    private String value;

    private PaymentType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static Optional<PaymentType> getByValue(String value) {
        return Optional.ofNullable(container.get(value));
    }

    static {
        container = new HashMap<String, PaymentType>();
        for (PaymentType type : PaymentType.values()) {
            container.put(type.getValue(), type);
        }
    }
}

