/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.web;

import de.adorsys.aspsp.aspspmockserver.domain.TanHolder;
import de.adorsys.aspsp.aspspmockserver.service.TanGettingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Profile(value={"test"})
@RestController
@RequestMapping(path={"/consent/tan"})
@Api(tags={"Tan getting controller"}, description="Returns tan number (for testing purposes only!)")
public class TanGettingController {
    private final TanGettingService tanGettingService;

    @GetMapping(path={"/{psu-id}"})
    @ApiOperation(value="Returns last unused tan by psu id", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=TanHolder.class), @ApiResponse(code=204, message="No content")})
    public ResponseEntity<TanHolder> getTan(@PathVariable(value="psu-id") String psuId) {
        return this.tanGettingService.getUnusedTanNumberByPsuId(psuId).map(tanHolder -> new ResponseEntity(tanHolder, HttpStatus.OK)).orElseGet(() -> ((ResponseEntity.HeadersBuilder)ResponseEntity.noContent()).build());
    }

    @ConstructorProperties(value={"tanGettingService"})
    public TanGettingController(TanGettingService tanGettingService) {
        this.tanGettingService = tanGettingService;
    }
}

