/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.service;

import de.adorsys.aspsp.aspspmockserver.domain.TanHolder;
import de.adorsys.aspsp.aspspmockserver.repository.TanRepository;
import de.adorsys.aspsp.aspspmockserver.service.AccountService;
import de.adorsys.psd2.aspsp.mock.api.psu.TanStatus;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Profile(value={"test"})
@Service
public class TanGettingService {
    private final TanRepository tanRepository;
    private final AccountService accountService;

    public Optional<TanHolder> getUnusedTanNumberByPsuId(String psuId) {
        Optional psuOptional = this.accountService.getPsuByPsuId(psuId);
        if (!psuOptional.isPresent()) {
            return Optional.empty();
        }
        return this.tanRepository.findByPsuIdAndTanStatus(psuId, TanStatus.UNUSED).stream().findFirst().map(tan -> new TanHolder(tan.getTanNumber()));
    }

    @ConstructorProperties(value={"tanRepository", "accountService"})
    public TanGettingService(TanRepository tanRepository, AccountService accountService) {
        this.tanRepository = tanRepository;
        this.accountService = accountService;
    }
}

