/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.service;

import de.adorsys.aspsp.aspspmockserver.data.test.AccountMockServerData;
import de.adorsys.aspsp.aspspmockserver.repository.PaymentRepository;
import de.adorsys.aspsp.aspspmockserver.repository.PsuRepository;
import de.adorsys.aspsp.aspspmockserver.repository.TanRepository;
import de.adorsys.aspsp.aspspmockserver.repository.TransactionRepository;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class IntegrationTestsService {
    private static final Logger log = LoggerFactory.getLogger(IntegrationTestsService.class);
    private final PaymentRepository paymentRepository;
    private final PsuRepository psuRepository;
    private final TransactionRepository transactionRepository;
    private final TanRepository tanRepository;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    DefaultListableBeanFactory beanFactory;

    public void refreshTestingData() {
        this.paymentRepository.deleteAll();
        this.psuRepository.deleteAll();
        this.transactionRepository.deleteAll();
        this.tanRepository.deleteAll();
        AccountMockServerData accountMockServerData = (AccountMockServerData)this.applicationContext.getBean(AccountMockServerData.class);
        this.beanFactory.destroyBean((Object)accountMockServerData);
        this.beanFactory.createBean(AccountMockServerData.class);
    }

    @ConstructorProperties(value={"paymentRepository", "psuRepository", "transactionRepository", "tanRepository", "applicationContext", "beanFactory"})
    public IntegrationTestsService(PaymentRepository paymentRepository, PsuRepository psuRepository, TransactionRepository transactionRepository, TanRepository tanRepository, ApplicationContext applicationContext, DefaultListableBeanFactory beanFactory) {
        this.paymentRepository = paymentRepository;
        this.psuRepository = psuRepository;
        this.transactionRepository = transactionRepository;
        this.tanRepository = tanRepository;
        this.applicationContext = applicationContext;
        this.beanFactory = beanFactory;
    }
}

