/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.service;

import de.adorsys.aspsp.aspspmockserver.service.AccountService;
import de.adorsys.aspsp.aspspmockserver.service.PaymentService;
import de.adorsys.psd2.aspsp.mock.api.account.AspspAccountBalance;
import de.adorsys.psd2.aspsp.mock.api.account.AspspAccountDetails;
import de.adorsys.psd2.aspsp.mock.api.common.AspspAmount;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Currency;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class FutureBookingsService {
    private final AccountService accountService;
    private final PaymentService paymentService;

    public Optional<AspspAccountDetails> changeBalances(String iban, String currency) {
        return this.accountService.getAccountsByIban(iban).stream().filter(acc -> this.areCurrenciesEqual(acc.getCurrency(), currency)).findFirst().flatMap(arg_0 -> this.updateAccountBalance(arg_0));
    }

    private Optional<AspspAccountDetails> updateAccountBalance(AspspAccountDetails account) {
        return this.calculateNewBalance(account).flatMap(bal -> this.saveNewBalanceToAccount(account, bal));
    }

    private Optional<AspspAccountDetails> saveNewBalanceToAccount(AspspAccountDetails account, AspspAccountBalance balance) {
        account.updateFirstBalance(balance);
        return this.accountService.updateAccount(account);
    }

    private Optional<AspspAccountBalance> calculateNewBalance(AspspAccountDetails account) {
        return account.getFirstBalance().map(bal -> this.getNewBalance(account, bal));
    }

    private AspspAccountBalance getNewBalance(AspspAccountDetails account, AspspAccountBalance balance) {
        AspspAccountBalance newAccountBalance = new AspspAccountBalance();
        newAccountBalance.setSpiBalanceAmount(this.getNewAmount(account, balance));
        newAccountBalance.setLastChangeDateTime(LocalDateTime.now());
        newAccountBalance.setReferenceDate(LocalDate.now());
        return balance;
    }

    private AspspAmount getNewAmount(AspspAccountDetails account, AspspAccountBalance b) {
        return new AspspAmount(Currency.getInstance("EUR"), this.getNewBalanceAmount(account, b));
    }

    private BigDecimal getNewBalanceAmount(AspspAccountDetails account, AspspAccountBalance balance) {
        BigDecimal oldBalanceAmount = balance.getSpiBalanceAmount().getAmount();
        return oldBalanceAmount.subtract(this.paymentService.calculateAmountToBeCharged(account.getResourceId()));
    }

    private boolean areCurrenciesEqual(Currency accountCurrency, String givenCurrency) {
        return Optional.ofNullable(accountCurrency).map(curr -> curr.getCurrencyCode().equals(givenCurrency)).orElse(false);
    }

    @ConstructorProperties(value={"accountService", "paymentService"})
    public FutureBookingsService(AccountService accountService, PaymentService paymentService) {
        this.accountService = accountService;
        this.paymentService = paymentService;
    }
}

