/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.config.email;

import de.adorsys.aspsp.aspspmockserver.config.email.EmailConfigurationProperties;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
public class EmailConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmailConfiguration.class);
    private final EmailConfigurationProperties emailConfigurationProperties;

    @Bean
    public JavaMailSender javaMailSender() {
        if (this.isParametersExist()) {
            JavaMailSenderImpl sender = new JavaMailSenderImpl();
            sender.setHost(this.emailConfigurationProperties.getHost());
            sender.setPort(Integer.parseInt(this.emailConfigurationProperties.getPort()));
            sender.setUsername(this.emailConfigurationProperties.getUsername());
            sender.setPassword(this.emailConfigurationProperties.getPassword());
            sender.setJavaMailProperties(this.buildMailProperties());
            return sender;
        }
        log.warn("Email properties has not been set");
        return null;
    }

    private Properties buildMailProperties() {
        Properties props = new Properties();
        Map properties = this.emailConfigurationProperties.getProperties();
        props.put("mail.smtp.auth", (Object)Boolean.parseBoolean((String)properties.get("mail.smtp.auth")));
        props.put("mail.smtp.starttls.enable", (Object)Boolean.parseBoolean((String)properties.get("mail.smtp.starttls.enable")));
        return props;
    }

    private boolean isParametersExist() {
        return StringUtils.isNotBlank((CharSequence)this.emailConfigurationProperties.getHost()) && StringUtils.isNotBlank((CharSequence)this.emailConfigurationProperties.getPort()) && this.isAuthParametersExist();
    }

    private boolean isAuthParametersExist() {
        Map properties = this.emailConfigurationProperties.getProperties();
        return MapUtils.isNotEmpty((Map)properties) && !Boolean.parseBoolean((String)properties.get("mail.smtp.auth")) || StringUtils.isNotBlank((CharSequence)this.emailConfigurationProperties.getUsername()) && StringUtils.isNotBlank((CharSequence)this.emailConfigurationProperties.getPassword());
    }

    @ConstructorProperties(value={"emailConfigurationProperties"})
    public EmailConfiguration(EmailConfigurationProperties emailConfigurationProperties) {
        this.emailConfigurationProperties = emailConfigurationProperties;
    }
}

