/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.web;

import de.adorsys.aspsp.aspspmockserver.service.PaymentService;
import de.adorsys.psd2.aspsp.mock.api.common.AspspTransactionStatus;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspPaymentInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/payments/common"})
@Api(tags={"Common payments"}, description="Provides access to common payments")
public class CommonPaymentController {
    private final PaymentService paymentService;

    @ApiOperation(value="Creates a payment based on request body", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=AspspPaymentInfo.class), @ApiResponse(code=204, message="Payment Failed")})
    @PostMapping
    public ResponseEntity<AspspPaymentInfo> createPayment(@RequestBody AspspPaymentInfo aspspPaymentInfo) {
        return this.paymentService.addPaymentInfo(aspspPaymentInfo).map(saved -> new ResponseEntity(saved, HttpStatus.CREATED)).orElseGet(() -> ((ResponseEntity.HeadersBuilder)ResponseEntity.noContent()).build());
    }

    @ApiOperation(value="Returns the payment requested by it`s ASPSP identifier", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=AspspPaymentInfo.class), @ApiResponse(code=404, message="Payment Not Found")})
    @GetMapping(path={"/{paymentId}"})
    public ResponseEntity<AspspPaymentInfo> getPaymentById(@PathVariable(value="paymentId") String paymentId) {
        Optional paymentOpt = this.paymentService.getCommonPaymentById(paymentId);
        return paymentOpt.isPresent() ? ResponseEntity.ok(paymentOpt.get()) : ResponseEntity.notFound().build();
    }

    @ApiOperation(value="Returns the status of payment requested by it`s ASPSP identifier", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=AspspTransactionStatus.class), @ApiResponse(code=404, message="Payment Not Found")})
    @GetMapping(path={"/{paymentId}/status"})
    public ResponseEntity<AspspTransactionStatus> getPaymentStatusById(@PathVariable(value="paymentId") String paymentId) {
        return this.paymentService.getPaymentStatusById(paymentId).map(ResponseEntity::ok).orElseGet(() -> ((ResponseEntity.HeadersBuilder)ResponseEntity.noContent()).build());
    }

    @ConstructorProperties(value={"paymentService"})
    public CommonPaymentController(PaymentService paymentService) {
        this.paymentService = paymentService;
    }
}

