/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.domain.ais;

import de.adorsys.aspsp.aspspmockserver.domain.ais.AisAccountAccessInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Arrays;

@ApiModel(description="Ais consent request", value="AisConsentRequest")
public class CreateAisConsentRequest {
    @ApiModelProperty(value="ID of the corresponding PSU", required=true, example="32aad578-58a6-4d5d-8b0c-45546dd88f07")
    private String psuId;
    @ApiModelProperty(value="ID of the corresponding TPP.", required=true, example="testTPP")
    private String tppId;
    @ApiModelProperty(value="Requested maximum frequency for an access per day. For a once-off access, this attribute is set to 1", required=true, example="4")
    private int frequencyPerDay;
    @ApiModelProperty(value="Set of accesses given by psu for this account", required=true)
    private AisAccountAccessInfo access;
    @ApiModelProperty(value="Consent`s expiration date. The content is the local ASPSP date in ISODate Format", required=true, example="2020-10-10")
    private LocalDate validUntil;
    @ApiModelProperty(value="'true', if the consent is for recurring access to the account data , 'false', if the consent is for one access to the account data", required=true, example="false")
    private boolean recurringIndicator;
    @ApiModelProperty(name="tppRedirectPreferred", value="If it equals \u201ctrue\u201d, the TPP prefers a redirect over an embedded SCA approach.", example="true")
    private boolean tppRedirectPreferred;
    @ApiModelProperty(value="If 'true' indicates that a payment initiation service will be addressed in the same 'session'", required=true, example="false")
    private boolean combinedServiceIndicator;
    @ApiModelProperty(value="ASPSP consent data", example="zzzzzzzz")
    private byte[] aspspConsentData;

    public String getPsuId() {
        return this.psuId;
    }

    public String getTppId() {
        return this.tppId;
    }

    public int getFrequencyPerDay() {
        return this.frequencyPerDay;
    }

    public AisAccountAccessInfo getAccess() {
        return this.access;
    }

    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    public boolean isRecurringIndicator() {
        return this.recurringIndicator;
    }

    public boolean isTppRedirectPreferred() {
        return this.tppRedirectPreferred;
    }

    public boolean isCombinedServiceIndicator() {
        return this.combinedServiceIndicator;
    }

    public byte[] getAspspConsentData() {
        return this.aspspConsentData;
    }

    public void setPsuId(String psuId) {
        this.psuId = psuId;
    }

    public void setTppId(String tppId) {
        this.tppId = tppId;
    }

    public void setFrequencyPerDay(int frequencyPerDay) {
        this.frequencyPerDay = frequencyPerDay;
    }

    public void setAccess(AisAccountAccessInfo access) {
        this.access = access;
    }

    public void setValidUntil(LocalDate validUntil) {
        this.validUntil = validUntil;
    }

    public void setRecurringIndicator(boolean recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
    }

    public void setTppRedirectPreferred(boolean tppRedirectPreferred) {
        this.tppRedirectPreferred = tppRedirectPreferred;
    }

    public void setCombinedServiceIndicator(boolean combinedServiceIndicator) {
        this.combinedServiceIndicator = combinedServiceIndicator;
    }

    public void setAspspConsentData(byte[] aspspConsentData) {
        this.aspspConsentData = aspspConsentData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateAisConsentRequest)) {
            return false;
        }
        CreateAisConsentRequest other = (CreateAisConsentRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$psuId = this.getPsuId();
        String other$psuId = other.getPsuId();
        if (this$psuId == null ? other$psuId != null : !this$psuId.equals(other$psuId)) {
            return false;
        }
        String this$tppId = this.getTppId();
        String other$tppId = other.getTppId();
        if (this$tppId == null ? other$tppId != null : !this$tppId.equals(other$tppId)) {
            return false;
        }
        if (this.getFrequencyPerDay() != other.getFrequencyPerDay()) {
            return false;
        }
        AisAccountAccessInfo this$access = this.getAccess();
        AisAccountAccessInfo other$access = other.getAccess();
        if (this$access == null ? other$access != null : !this$access.equals(other$access)) {
            return false;
        }
        LocalDate this$validUntil = this.getValidUntil();
        LocalDate other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !((Object)this$validUntil).equals(other$validUntil)) {
            return false;
        }
        if (this.isRecurringIndicator() != other.isRecurringIndicator()) {
            return false;
        }
        if (this.isTppRedirectPreferred() != other.isTppRedirectPreferred()) {
            return false;
        }
        if (this.isCombinedServiceIndicator() != other.isCombinedServiceIndicator()) {
            return false;
        }
        return Arrays.equals(this.getAspspConsentData(), other.getAspspConsentData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateAisConsentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $psuId = this.getPsuId();
        result = result * 59 + ($psuId == null ? 43 : $psuId.hashCode());
        String $tppId = this.getTppId();
        result = result * 59 + ($tppId == null ? 43 : $tppId.hashCode());
        result = result * 59 + this.getFrequencyPerDay();
        AisAccountAccessInfo $access = this.getAccess();
        result = result * 59 + ($access == null ? 43 : $access.hashCode());
        LocalDate $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : ((Object)$validUntil).hashCode());
        result = result * 59 + (this.isRecurringIndicator() ? 79 : 97);
        result = result * 59 + (this.isTppRedirectPreferred() ? 79 : 97);
        result = result * 59 + (this.isCombinedServiceIndicator() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getAspspConsentData());
        return result;
    }

    public String toString() {
        return "CreateAisConsentRequest(psuId=" + this.getPsuId() + ", tppId=" + this.getTppId() + ", frequencyPerDay=" + this.getFrequencyPerDay() + ", access=" + this.getAccess() + ", validUntil=" + this.getValidUntil() + ", recurringIndicator=" + this.isRecurringIndicator() + ", tppRedirectPreferred=" + this.isTppRedirectPreferred() + ", combinedServiceIndicator=" + this.isCombinedServiceIndicator() + ", aspspConsentData=" + Arrays.toString(this.getAspspConsentData()) + ")";
    }
}

