/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.data.test;

import de.adorsys.aspsp.aspspmockserver.domain.pis.AspspPayment;
import de.adorsys.aspsp.aspspmockserver.domain.pis.PisPaymentType;
import de.adorsys.aspsp.aspspmockserver.repository.AccountDetailsRepository;
import de.adorsys.aspsp.aspspmockserver.repository.PaymentRepository;
import de.adorsys.aspsp.aspspmockserver.repository.PsuRepository;
import de.adorsys.aspsp.aspspmockserver.repository.TanRepository;
import de.adorsys.aspsp.aspspmockserver.repository.TransactionRepository;
import de.adorsys.psd2.aspsp.mock.api.account.AspspAccountBalance;
import de.adorsys.psd2.aspsp.mock.api.account.AspspAccountDetails;
import de.adorsys.psd2.aspsp.mock.api.account.AspspAccountReference;
import de.adorsys.psd2.aspsp.mock.api.account.AspspBalanceType;
import de.adorsys.psd2.aspsp.mock.api.account.AspspTransaction;
import de.adorsys.psd2.aspsp.mock.api.common.AspspAmount;
import de.adorsys.psd2.aspsp.mock.api.common.AspspTransactionStatus;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspDayOfExecution;
import de.adorsys.psd2.aspsp.mock.api.psu.AspspAuthenticationObject;
import de.adorsys.psd2.aspsp.mock.api.psu.AspspPsuData;
import de.adorsys.psd2.aspsp.mock.api.psu.Psu;
import de.adorsys.psd2.aspsp.mock.api.psu.Tan;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"data_test"})
public class AccountMockServerData {
    private PsuRepository psuRepository;
    private TransactionRepository transactionRepository;
    private TanRepository tanRepository;
    private PaymentRepository paymentRepository;
    private List<AspspAccountDetails> accountDetails;
    private List<Psu> psus;
    private final List<String> ALLOWED_PAYMENTS = Collections.singletonList("sepa-credit-transfers");
    private final Currency EUR = Currency.getInstance("EUR");
    private final Currency USD = Currency.getInstance("USD");
    private final AspspBalanceType BALANCE_TYPE = AspspBalanceType.INTERIM_AVAILABLE;
    private final List<String> ALLOWED_PAYMENTS_CUCUMBER_TESTUSER = Arrays.asList("sepa-credit-transfers");

    public AccountMockServerData(PsuRepository psuRepository, TransactionRepository transactionRepository, TanRepository tanRepository, PaymentRepository paymentRepository, AccountDetailsRepository accountDetailsRepository) {
        this.psuRepository = psuRepository;
        this.transactionRepository = transactionRepository;
        this.tanRepository = tanRepository;
        this.paymentRepository = paymentRepository;
        this.accountDetails = this.fillAccounts();
        this.psus = this.fillPsu();
        this.fillTransactions();
        this.fillTanRepository();
        this.fillPayments();
        accountDetailsRepository.save((Iterable)this.accountDetails);
    }

    private void fillPayments() {
        this.paymentRepository.save((Object)this.getPayment("a9115f14-4f72-4e4e-8798-202808e85238", (Psu)this.psus.get(3), this.EUR, BigDecimal.valueOf(150L), (Psu)this.psus.get(7), "Online-Shoppping Amazon", LocalDate.parse("2018-07-15"), LocalDateTime.parse("2018-07-15T18:30:35.035"), AspspTransactionStatus.RCVD, PisPaymentType.SINGLE, AspspDayOfExecution._15));
        this.paymentRepository.save((Object)this.getPayment("68147b90-e4ef-41c6-9c8b-c848c1e93700", (Psu)this.psus.get(3), this.EUR, BigDecimal.valueOf(1030L), (Psu)this.psus.get(8), "Holidays", LocalDate.parse("2018-07-31"), LocalDateTime.parse("2018-07-31T18:30:35.035"), AspspTransactionStatus.PDNG, PisPaymentType.SINGLE, AspspDayOfExecution._31));
        this.paymentRepository.save((Object)this.getPayment("97694f0d-32e2-43a4-9e8d-261f2fc28236", (Psu)this.psus.get(3), this.EUR, BigDecimal.valueOf(70L), (Psu)this.psus.get(9), "Concert Tickets", LocalDate.parse("2018-07-08"), LocalDateTime.parse("2018-07-08T18:30:35.035"), AspspTransactionStatus.RJCT, PisPaymentType.SINGLE, AspspDayOfExecution._08));
    }

    private AspspPayment getPayment(String paymentId, Psu debtor, Currency currency, BigDecimal amount, Psu creditor, String purposeCode, LocalDate requestedExecutionDate, LocalDateTime requestedExecutionTime, AspspTransactionStatus paymentStatus, PisPaymentType paymentType, AspspDayOfExecution dayOfExecution) {
        AspspPayment payment = new AspspPayment();
        payment.setPaymentId(paymentId);
        payment.setDebtorAccount(this.getRef(debtor, currency));
        payment.setUltimateDebtor(this.getFirstElementName(debtor));
        payment.setInstructedAmount(new AspspAmount(currency, amount));
        payment.setCreditorAccount(this.getRef(creditor, currency));
        payment.setCreditorName(this.getFirstElementName(creditor));
        payment.setUltimateCreditor(this.getFirstElementName(creditor));
        payment.setPurposeCode(purposeCode);
        payment.setRequestedExecutionDate(requestedExecutionDate);
        payment.setRequestedExecutionTime(requestedExecutionTime);
        payment.setDayOfExecution(dayOfExecution);
        payment.setPisPaymentType(paymentType);
        payment.setPaymentStatus(paymentStatus);
        return payment;
    }

    private void fillTransactions() {
        this.transactionRepository.save((Object)this.getTransaction("0001", (Psu)this.psus.get(0), (Psu)this.psus.get(1), BigDecimal.valueOf(200L), this.EUR, LocalDate.parse("2018-01-02"), LocalDate.parse("2018-01-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("0002", (Psu)this.psus.get(0), (Psu)this.psus.get(1), BigDecimal.valueOf(150L), this.USD, null, LocalDate.parse("2018-01-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("0003", (Psu)this.psus.get(1), (Psu)this.psus.get(0), BigDecimal.valueOf(250L), this.EUR, LocalDate.parse("2018-02-02"), LocalDate.parse("2018-02-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("0004", (Psu)this.psus.get(1), (Psu)this.psus.get(0), BigDecimal.valueOf(20L), this.USD, null, LocalDate.parse("2018-02-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("0005", (Psu)this.psus.get(2), (Psu)this.psus.get(0), BigDecimal.valueOf(40L), this.EUR, LocalDate.parse("2018-03-02"), LocalDate.parse("2018-03-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("0006", (Psu)this.psus.get(2), (Psu)this.psus.get(1), BigDecimal.valueOf(50L), this.USD, null, LocalDate.parse("2018-01-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("0007", (Psu)this.psus.get(2), (Psu)this.psus.get(1), BigDecimal.valueOf(120L), this.EUR, LocalDate.parse("2018-01-02"), LocalDate.parse("2018-01-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("0008", (Psu)this.psus.get(1), (Psu)this.psus.get(2), BigDecimal.valueOf(30L), this.USD, null, LocalDate.parse("2018-02-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("0009", (Psu)this.psus.get(1), (Psu)this.psus.get(2), BigDecimal.valueOf(80L), this.EUR, LocalDate.parse("2018-02-02"), LocalDate.parse("2018-02-02"), ""));
        this.transactionRepository.save((Object)this.getTransaction("ba8f7012-bdaf-4ada-bbf7-4c004d046ffe", (Psu)this.psus.get(4), (Psu)this.psus.get(3), BigDecimal.valueOf(50L), this.EUR, LocalDate.parse("2018-07-05"), LocalDate.parse("2018-07-05"), "Spende Greenpeace"));
        this.transactionRepository.save((Object)this.getTransaction("7d12ff85-8ace-4124-877a-6bc3f125e98b", (Psu)this.psus.get(5), (Psu)this.psus.get(3), BigDecimal.valueOf(45.99), this.EUR, LocalDate.parse("2018-01-01"), LocalDate.parse("2018-01-01"), "Internet Rechnung Januar 2018 - MC-13058247-00000002"));
        this.transactionRepository.save((Object)this.getTransaction("bb0962ca-f6db-4ba7-b187-2b2e1af25845", (Psu)this.psus.get(6), (Psu)this.psus.get(3), BigDecimal.valueOf(200L), this.EUR, LocalDate.parse("2018-05-15"), LocalDate.parse("2018-05-15"), "Alles Gute zum Geburtstag"));
        this.transactionRepository.save((Object)this.getTransaction("abc962ca-f6db-4ba7-b187-2b2e1af2test", (Psu)this.psus.get(4), (Psu)this.psus.get(3), BigDecimal.valueOf(70L), this.EUR, LocalDate.parse("2018-11-24"), LocalDate.parse("2018-12-25"), "Spende fuer Nuernberg Bieber"));
    }

    private AspspTransaction getTransaction(String transactionId, Psu psu, Psu debtor, BigDecimal amount, Currency currency, LocalDate bookingDate, LocalDate valueDate, String purposeCode) {
        return new AspspTransaction(transactionId, "", "", "", "", psu.getPsuId(), bookingDate, valueDate, new AspspAmount(currency, amount), Collections.emptyList(), this.getFirstElementName(psu), this.getRef(psu, currency), this.getFirstElementName(psu), this.getFirstElementName(debtor), this.getRef(debtor, currency), this.getFirstElementName(debtor), "", "", purposeCode, "", "");
    }

    private String getFirstElementName(Psu creditor) {
        return ((AspspAccountDetails)creditor.getAccountDetailsList().get(0)).getName();
    }

    private AspspAccountReference getRef(Psu psu, Currency currency) {
        return psu.getAccountDetailsList().stream().filter(det -> det.getCurrency() == currency).map(arg_0 -> this.mapToReferenceFromDetails(arg_0)).findFirst().get();
    }

    private List<Psu> fillPsu() {
        return Arrays.asList((Psu)this.psuRepository.save((Object)new Psu("PSU_001", "johndoutestemail@gmail.com", "aspsp", "zzz", Arrays.asList((AspspAccountDetails)this.accountDetails.get(0), (AspspAccountDetails)this.accountDetails.get(1), (AspspAccountDetails)this.accountDetails.get(2)), this.ALLOWED_PAYMENTS, Collections.emptyList())), (Psu)this.psuRepository.save((Object)new Psu("PSU_002", "johndoutestemail@gmail.com", "aspsp1", "zzz", Arrays.asList((AspspAccountDetails)this.accountDetails.get(0), (AspspAccountDetails)this.accountDetails.get(1), (AspspAccountDetails)this.accountDetails.get(2)), this.ALLOWED_PAYMENTS, Arrays.asList(new AspspAuthenticationObject("SMS_OTP", "sms")))), (Psu)this.psuRepository.save((Object)new Psu("PSU_003", "johndoutestemail@gmail.com", "aspsp2", "zzz", Arrays.asList((AspspAccountDetails)this.accountDetails.get(3), (AspspAccountDetails)this.accountDetails.get(4)), this.ALLOWED_PAYMENTS, Arrays.asList(new AspspAuthenticationObject("SMS_OTP", "sms"), new AspspAuthenticationObject("PUSH_OTP", "push", true)))), (Psu)this.psuRepository.save((Object)new Psu("PSU_004", "johndoutestemail@gmail.com", "aspsp3", "zzz", Arrays.asList((AspspAccountDetails)this.accountDetails.get(5), (AspspAccountDetails)this.accountDetails.get(6)), this.ALLOWED_PAYMENTS, Arrays.asList(new AspspAuthenticationObject("PUSH_OTP", "push"), new AspspAuthenticationObject("CHIP_OTP", "chip")))), (Psu)this.psuRepository.save((Object)new Psu("d9e71419-24e4-4c5a-8d93-fcc23153aaff", "mueller.alex@web.de", "aspsp4", "zzz", Arrays.asList((AspspAccountDetails)this.accountDetails.get(7), (AspspAccountDetails)this.accountDetails.get(14)), this.ALLOWED_PAYMENTS_CUCUMBER_TESTUSER, Collections.singletonList(new AspspAuthenticationObject("SMS_OTP", "sms")))), (Psu)this.psuRepository.save((Object)new Psu("d9e71419-24e4-4c5a-8d93-fcc23153aaff", "mueller.alex@web.de", "aspsp5", "zzz", Arrays.asList((AspspAccountDetails)this.accountDetails.get(7), (AspspAccountDetails)this.accountDetails.get(14)), this.ALLOWED_PAYMENTS_CUCUMBER_TESTUSER, Collections.singletonList(new AspspAuthenticationObject("SMS_OTP", "sms", true)))), (Psu)this.psuRepository.save((Object)new Psu("PSU_CucumberGreenpeace", "greenpeace@web.de", "aspsp6", "zzz", Arrays.asList((AspspAccountDetails)this.accountDetails.get(8)), this.ALLOWED_PAYMENTS_CUCUMBER_TESTUSER, Collections.singletonList(new AspspAuthenticationObject("SMS_OTP", "sms")))), (Psu)this.psuRepository.save((Object)new Psu("PSU_CucumberTelekom", "telekom@telekom.de", "aspsp7", "zzz", Arrays.asList((AspspAccountDetails)this.accountDetails.get(9)), this.ALLOWED_PAYMENTS_CUCUMBER_TESTUSER, Collections.singletonList(new AspspAuthenticationObject("SMS_OTP", "sms")))), (Psu)this.psuRepository.save((Object)new Psu("PSU_CucumberJochen", "jochen.mueller@web.de", "aspsp8", "zzz", Arrays.asList((AspspAccountDetails)this.accountDetails.get(10)), this.ALLOWED_PAYMENTS_CUCUMBER_TESTUSER, Collections.singletonList(new AspspAuthenticationObject("SMS_OTP", "sms")))), (Psu)this.psuRepository.save((Object)new Psu("PSU_CucumberAmazon", "amazon@mail.com", "aspsp9", "zzz", Arrays.asList((AspspAccountDetails)this.accountDetails.get(11)), this.ALLOWED_PAYMENTS_CUCUMBER_TESTUSER, Collections.singletonList(new AspspAuthenticationObject("SMS_OTP", "sms")))), (Psu)this.psuRepository.save((Object)new Psu("PSU_CucumberHolidayCheck", "holidaycheck@mail.com", "aspsp10", "zzz", Arrays.asList((AspspAccountDetails)this.accountDetails.get(12)), this.ALLOWED_PAYMENTS_CUCUMBER_TESTUSER, Collections.singletonList(new AspspAuthenticationObject("SMS_OTP", "sms")))), (Psu)this.psuRepository.save((Object)new Psu("PSU_CucumberEventim", "eventim@web.de", "aspsp11", "zzz", Arrays.asList((AspspAccountDetails)this.accountDetails.get(13)), this.ALLOWED_PAYMENTS_CUCUMBER_TESTUSER, Collections.singletonList(new AspspAuthenticationObject("SMS_OTP", "sms")))));
    }

    private List<AspspAccountDetails> fillAccounts() {
        return Arrays.asList(this.getNewAccount("11111-11111", "11111-999999999", this.getNewBalanceList(this.EUR, BigDecimal.valueOf(1000L)), "DE89370400440532013000", "AEYPM5403H", "DEUTDE8EXXX", "M\u00fcller", "SCT", Collections.singletonList(new AspspPsuData("PSU_001", "psu-type", "123456", "corp-type"))), this.getNewAccount("11111-11111", "77777-999999999", this.getNewBalanceList(this.USD, BigDecimal.valueOf(350L)), "DE89370400440532013000", "FFGHPM5403H", "DEUTDE8EXXX", "M\u00fcller", "SCT", Collections.singletonList(new AspspPsuData("PSU_001", "psu-type", "123456", "corp-type"))), this.getNewAccount("22222-22222", "22222-999999999", this.getNewBalanceList(this.USD, BigDecimal.valueOf(2500L)), "DE89370400440532013001", "QWEPM6427U", "DEUTDE8EXXX", "M\u00fcller", "SCT", Collections.singletonList(new AspspPsuData("PSU_001", "psu-type", "123456", "corp-type"))), this.getNewAccount("33333-33333", "33333-999999999", this.getNewBalanceList(this.EUR, BigDecimal.valueOf(3000L)), "LU280019400644750000", "EWQPS8534R", "DEUTDE8EXXX", "Schmidt", "SCT", Collections.singletonList(new AspspPsuData("PSU_001", "psu-type", "123456", "corp-type"))), this.getNewAccount("44444-44444", "44444-999999999", this.getNewBalanceList(this.USD, BigDecimal.valueOf(3500L)), "DE89370400440532013003", "ASDPS9547Z", "DEUTDE8EXXX", "Schmidt", "SCT", Arrays.asList(new AspspPsuData("aspsp", "psu-type", "123456", "corp-type"), new AspspPsuData("aspsp1", "psu-type", "123456", "corp-type"), new AspspPsuData("aspsp2", "psu-type", "123456", "corp-type"))), this.getNewAccount("55555-55555", "55555-999999999", this.getNewBalanceList(this.EUR, BigDecimal.valueOf(4000L)), "DE89370400440532013004", "DSACC1876N", "DEUTDE8EXXX", "Company AG", "SCT", Arrays.asList(new AspspPsuData("aspsp1", "psu-type", "123456", "corp-type"), new AspspPsuData("aspsp2", "psu-type", "123456", "corp-type"))), this.getNewAccount("66666-66666", "66666-999999999", this.getNewBalanceList(this.USD, BigDecimal.valueOf(1400L)), "DE89370400440532013005", "CXZCC6427T", "DEUTDE8EXXX", "Company AG", "SCT", Collections.singletonList(new AspspPsuData("PSU_001", "psu-type", "123456", "corp-type"))), this.getNewAccount("11111-11111", "66666-999999999", this.getNewBalanceList(this.USD, BigDecimal.valueOf(1400L)), "DE52500105173911841934", "CXZCC6427T", "DEUTDE8EXXX", "Company AG", "SCT", Collections.singletonList(new AspspPsuData("PSU_001", "psu-type", "123456", "corp-type"))), this.getNewAccountCucumberTest("11111-11112", "42fb4cc3-91cb-45ba-9159-b87acf6d8add", this.getNewBalanceListCucumberTests(this.EUR, BigDecimal.valueOf(50000L)), "DE52500105173911841934", null, null, "Alexander Mueller", "GIRO", Collections.singletonList(new AspspPsuData("PSU_001", "psu-type", "123456", "corp-type"))), this.getNewAccountCucumberTest("11111-11113", "88888-999999999", this.getNewBalanceListCucumberTests(this.EUR, BigDecimal.valueOf(1000000L)), "DE24500105172916349286", null, null, "Greenpeace", "GIRO", Collections.singletonList(new AspspPsuData("PSU_001", "psu-type", "123456", "corp-type"))), this.getNewAccountCucumberTest("11111-11114", "99999-999999999", this.getNewBalanceListCucumberTests(this.EUR, BigDecimal.valueOf(500000L)), "DE68500105174416628385", null, null, "Telekom", "GIRO", Collections.singletonList(new AspspPsuData("PSU_001", "psu-type", "123456", "corp-type"))), this.getNewAccountCucumberTest("11111-11115", "12345-999999999", this.getNewBalanceListCucumberTests(this.EUR, BigDecimal.valueOf(20000L)), "DE06500105171657611553", null, null, "Jochen Mueller", "GIRO", Collections.singletonList(new AspspPsuData("PSU_001", "psu-type", "123456", "corp-type"))), this.getNewAccountCucumberTest("11111-11116", "23236-999999999", this.getNewBalanceListCucumberTests(this.EUR, BigDecimal.valueOf(6500000L)), "DE49500105175378548627", null, null, "Amazon", "GIRO", Collections.singletonList(new AspspPsuData("PSU_001", "psu-type", "123456", "corp-type"))), this.getNewAccountCucumberTest("11111-11117", "37289-999999999", this.getNewBalanceListCucumberTests(this.EUR, BigDecimal.valueOf(9500000L)), "DE21500105176194357737", null, null, "Holidaycheck.com", "GIRO", Collections.singletonList(new AspspPsuData("PSU_001", "psu-type", "123456", "corp-type"))), this.getNewAccountCucumberTest("11111-11118", "10023-999999999", this.getNewBalanceListCucumberTests(this.EUR, BigDecimal.valueOf(2500000L)), "DE54500105173424724776", null, null, "Eventim", "GIRO", Collections.singletonList(new AspspPsuData("PSU_001", "psu-type", "123456", "corp-type"))), this.getNewAccountCucumberTest("11111-11119", "868beafc-ef87-4fdb-ac0a-dd6c52b77ee6", this.getNewBalanceListCucumberTests(this.EUR, BigDecimal.valueOf(50000L)), "DE15086016167627403587", null, null, "Alexander Mueller", "GIRO", Collections.singletonList(new AspspPsuData("PSU_001", "psu-type", "123456", "corp-type"))));
    }

    private AspspAccountDetails getNewAccount(String aspspAccountId, String resourceId, List<AspspAccountBalance> balance, String iban, String pan, String bic, String name, String accountType, List<AspspPsuData> psuDataList) {
        return new AspspAccountDetails(aspspAccountId, resourceId, iban, iban.substring(3), pan, pan.substring(3) + "****", null, balance.get(0).getSpiBalanceAmount().getCurrency(), name, accountType, null, null, psuDataList, bic, null, null, null, balance);
    }

    private List<AspspAccountBalance> getNewBalanceList(Currency currency, BigDecimal amount1) {
        return Collections.singletonList(this.getBalance(currency, amount1, LocalDate.now(), LocalDateTime.now()));
    }

    private AspspAccountBalance getBalance(Currency currency, BigDecimal amount, LocalDate date, LocalDateTime dateTime) {
        AspspAccountBalance balance = new AspspAccountBalance();
        balance.setSpiBalanceAmount(new AspspAmount(currency, amount));
        balance.setSpiBalanceType(this.BALANCE_TYPE);
        balance.setReferenceDate(date);
        balance.setLastChangeDateTime(dateTime);
        balance.setLastCommittedTransaction("abcd");
        return balance;
    }

    private AspspAccountDetails getNewAccountCucumberTest(String aspspAccountId, String resourceId, List<AspspAccountBalance> balance, String iban, String pan, String bic, String name, String accountType, List<AspspPsuData> psuDataList) {
        return new AspspAccountDetails(aspspAccountId, resourceId, iban, iban.substring(3), pan, null, null, balance.get(0).getSpiBalanceAmount().getCurrency(), name, accountType, null, null, psuDataList, bic, null, null, null, balance);
    }

    private List<AspspAccountBalance> getNewBalanceListCucumberTests(Currency currency, BigDecimal amount1) {
        return Collections.singletonList(this.getBalance(currency, amount1, LocalDate.now(), LocalDateTime.now()));
    }

    private AspspAccountReference mapToReferenceFromDetails(AspspAccountDetails details) {
        return new AspspAccountReference(details.getResourceId(), details.getIban(), details.getBban(), details.getPan(), details.getMaskedPan(), details.getMsisdn(), details.getCurrency());
    }

    private void fillTanRepository() {
        this.tanRepository.save((Object)new Tan("PSU_001", "111111"));
        this.tanRepository.save((Object)new Tan("PSU_002", "222222"));
        this.tanRepository.save((Object)new Tan("PSU_003", "333333"));
    }
}

