/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.keycloak;

import de.adorsys.aspsp.aspspmockserver.config.KeycloakConfigProperties;
import java.beans.ConstructorProperties;
import java.util.Collections;
import javax.ws.rs.core.Response;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class KeycloakService {
    private static final Logger log = LoggerFactory.getLogger(KeycloakService.class);
    private static final String ADMIN_CLI = "admin-cli";
    private static final String MASTER_REALM = "master";
    private static final String USER_ROLE = "user";
    private final KeycloakConfigProperties keycloakConfigProperties;
    @Value(value="${keycloak-admin-username}")
    private String keycloakAdminUsername;
    @Value(value="${keycloak-admin-password}")
    private String keycloakAdminPassword;

    public boolean registerClient(String psuId, String password, String email) {
        Keycloak keycloak = Keycloak.getInstance((String)this.keycloakConfigProperties.getAuthServerUrl(), (String)MASTER_REALM, (String)this.keycloakAdminUsername, (String)this.keycloakAdminPassword, (String)ADMIN_CLI);
        try (Response response = keycloak.realm(this.keycloakConfigProperties.getRealm()).users().create(this.getUserRepresentation(psuId, password, email));){
            log.info("Register keycloak client status: {}", (Object)response.getStatus());
            boolean bl = response.getStatus() == 201;
            return bl;
        }
    }

    private UserRepresentation getUserRepresentation(String psuId, String password, String email) {
        CredentialRepresentation credential = new CredentialRepresentation();
        credential.setType("password");
        credential.setValue(password);
        credential.setTemporary(Boolean.valueOf(false));
        UserRepresentation user = new UserRepresentation();
        user.setUsername(psuId);
        user.setEmail(email);
        user.setCredentials(Collections.singletonList(credential));
        user.setRealmRoles(Collections.singletonList(USER_ROLE));
        user.setEnabled(Boolean.valueOf(true));
        return user;
    }

    @ConstructorProperties(value={"keycloakConfigProperties"})
    public KeycloakService(KeycloakConfigProperties keycloakConfigProperties) {
        this.keycloakConfigProperties = keycloakConfigProperties;
    }
}

