/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.service;

import de.adorsys.aspsp.aspspmockserver.repository.PsuRepository;
import de.adorsys.psd2.aspsp.mock.api.account.AspspAccountBalance;
import de.adorsys.psd2.aspsp.mock.api.account.AspspAccountDetails;
import de.adorsys.psd2.aspsp.mock.api.psu.Psu;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class AccountService {
    private final PsuRepository psuRepository;

    public Optional<AspspAccountDetails> addAccount(String psuId, AspspAccountDetails accountDetails) {
        return Optional.ofNullable(this.psuRepository.findOne((Serializable)((Object)psuId))).map(psu -> this.addAccountToPsuAndSave(psu, accountDetails)).flatMap(psu -> this.findAccountInPsuById(psu, accountDetails.getResourceId()));
    }

    public List<AspspAccountDetails> getAllAccounts() {
        return this.psuRepository.findAll().stream().flatMap(psu -> psu.getAccountDetailsList().stream()).collect(Collectors.toList());
    }

    public Optional<AspspAccountDetails> getAccountById(String accountId) {
        return this.psuRepository.findPsuByAccountDetailsList_ResourceId(accountId).flatMap(psu -> this.findAccountInPsuById(psu, accountId));
    }

    public List<AspspAccountDetails> getAccountsByIban(String iban) {
        return this.psuRepository.findPsuByAccountDetailsList_Iban(iban).map(Psu::getAccountDetailsList).orElseGet(Collections::emptyList);
    }

    Optional<String> getAccountIdByIbanAndCurrency(String iban, Currency currency) {
        return this.psuRepository.findPsuByAccountDetailsList_Iban(iban).flatMap(psu -> psu.getAccountDetailsList().stream().filter(aD -> aD.getCurrency() == currency).findFirst().map(AspspAccountDetails::getAspspAccountId));
    }

    Optional<String> getPsuIdByIban(String iban) {
        return this.psuRepository.findPsuByAccountDetailsList_Iban(iban).map(Psu::getPsuId);
    }

    Optional<Psu> getPsuByPsuId(String psuId) {
        return this.psuRepository.findByPsuId(psuId);
    }

    public List<AspspAccountBalance> getAccountBalancesById(String accountId) {
        return this.psuRepository.findPsuByAccountDetailsList_ResourceId(accountId).flatMap(psu -> this.findAccountInPsuById(psu, accountId)).map(AspspAccountDetails::getBalances).orElseGet(Collections::emptyList);
    }

    public List<AspspAccountDetails> getAccountsByPsuId(String psuId) {
        return this.psuRepository.findByPsuId(psuId).map(Psu::getAccountDetailsList).orElseGet(Collections::emptyList);
    }

    public void deleteAccountById(String accountId) {
        this.psuRepository.findPsuByAccountDetailsList_ResourceId(accountId).map(psu -> this.getPsuWithFilteredAccountListById(psu, accountId)).map(arg_0 -> ((PsuRepository)this.psuRepository).save(arg_0));
    }

    Optional<AspspAccountDetails> updateAccount(AspspAccountDetails accountDetails) {
        return Optional.ofNullable(accountDetails.getResourceId()).flatMap(arg_0 -> ((PsuRepository)this.psuRepository).findPsuByAccountDetailsList_ResourceId(arg_0)).map(psu -> this.updateAccountInPsu(psu, accountDetails)).flatMap(psu -> this.findAccountInPsuById(psu, accountDetails.getResourceId()));
    }

    private Psu updateAccountInPsu(Psu psu, AspspAccountDetails accountDetails) {
        Psu filteredPsu = this.getPsuWithFilteredAccountListById(psu, accountDetails.getResourceId());
        return this.addAccountToPsuAndSave(filteredPsu, accountDetails);
    }

    private Optional<AspspAccountDetails> findAccountInPsuById(Psu psu, String accountId) {
        return psu.getAccountDetailsList().stream().filter(acc -> acc.getResourceId().equals(accountId)).findFirst();
    }

    private Psu getPsuWithFilteredAccountListById(Psu psu, String accountId) {
        psu.setAccountDetailsList(this.getFilteredAccountDetailsListFromPsuById(psu, accountId));
        return psu;
    }

    private Psu addAccountToPsuAndSave(Psu psu, AspspAccountDetails accountDetails) {
        psu.getAccountDetailsList().add(accountDetails);
        return (Psu)this.psuRepository.save((Object)psu);
    }

    private List<AspspAccountDetails> getFilteredAccountDetailsListFromPsuById(Psu psu, String accountId) {
        return psu.getAccountDetailsList().stream().filter(ad -> !ad.getResourceId().equals(accountId)).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"psuRepository"})
    public AccountService(PsuRepository psuRepository) {
        this.psuRepository = psuRepository;
    }
}

