/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.web;

import de.adorsys.aspsp.aspspmockserver.domain.pis.AspspPayment;
import de.adorsys.aspsp.aspspmockserver.service.PaymentService;
import de.adorsys.psd2.aspsp.mock.api.common.AspspTransactionStatus;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspBulkPayment;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspPaymentCancellationResponse;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspPeriodicPayment;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspSinglePayment;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/payments"})
@Api(tags={"Payments"}, description="Provides access to payments")
public class PaymentController {
    private PaymentService paymentService;

    @ApiOperation(value="Creates a single payment based on request body", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=AspspSinglePayment.class), @ApiResponse(code=204, message="Payment Failed")})
    @PostMapping(path={"/"})
    public ResponseEntity<AspspSinglePayment> createSinglePayment(@RequestBody AspspSinglePayment payment) {
        return this.paymentService.addPayment(payment).map(saved -> new ResponseEntity(saved, HttpStatus.CREATED)).orElseGet(() -> ((ResponseEntity.HeadersBuilder)ResponseEntity.noContent()).build());
    }

    @ApiOperation(value="Creates a periodic payment based on request body", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=AspspPeriodicPayment.class), @ApiResponse(code=400, message="Bad Request")})
    @PostMapping(path={"/create-periodic-payment"})
    public ResponseEntity<AspspPeriodicPayment> createPeriodicPayment(@RequestBody AspspPeriodicPayment payment) {
        return this.paymentService.addPeriodicPayment(payment).map(saved -> new ResponseEntity(saved, HttpStatus.CREATED)).orElseGet(() -> ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest()).build());
    }

    @ApiOperation(value="Creates a bulk payment(list of single payments) based on request body", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=List.class), @ApiResponse(code=400, message="Payment Failed")})
    @PostMapping(path={"/bulk-payments"})
    public ResponseEntity<AspspBulkPayment> createBulkPayments(@RequestBody AspspBulkPayment bulkPayment) {
        return this.paymentService.addBulkPayments(bulkPayment).map(saved -> new ResponseEntity(saved, HttpStatus.CREATED)).orElseGet(() -> ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest()).build());
    }

    @ApiOperation(value="Returns the status of payment requested by it`s ASPSP identifier", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=AspspTransactionStatus.class), @ApiResponse(code=204, message="Payment Not Found")})
    @GetMapping(path={"/{paymentId}/status"})
    public ResponseEntity<AspspTransactionStatus> getPaymentStatusById(@PathVariable(value="paymentId") String paymentId) {
        return this.paymentService.getPaymentStatusById(paymentId).map(ResponseEntity::ok).orElseGet(() -> ((ResponseEntity.HeadersBuilder)ResponseEntity.noContent()).build());
    }

    @ApiOperation(value="Returns all payments present at ASPSP", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=AspspPayment.class)})
    @GetMapping(path={"/getAllPayments"})
    public ResponseEntity<List<AspspPayment>> getAllPayments() {
        List allPayments = this.paymentService.getAllPayments();
        return ResponseEntity.ok((Object)allPayments);
    }

    @ApiOperation(value="Returns the payment requested by it`s ASPSP identifier", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=AspspPayment.class), @ApiResponse(code=204, message="Payment Not Found")})
    @GetMapping(path={"/{payment-type}/{payment-product}/{paymentId}"})
    public ResponseEntity<List<AspspPayment>> getPaymentByIdAndTypeAndProduct(@PathVariable(value="payment-type") String paymentType, @PathVariable(value="payment-product") String paymentProduct, @PathVariable(value="paymentId") String paymentId) {
        List response = this.paymentService.getPaymentById(paymentId);
        return CollectionUtils.isNotEmpty((Collection)response) ? ResponseEntity.ok((Object)response) : ResponseEntity.noContent().build();
    }

    @ApiOperation(value="Cancel payment by it`s ASPSP identifier", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=202, message="ACCEPTED", response=AspspPaymentCancellationResponse.class), @ApiResponse(code=404, message="Payment Not Found")})
    @DeleteMapping(value={"/{payment-id}"})
    public ResponseEntity<Void> cancelPayment(@PathVariable(value="payment-id") String paymentId) {
        return this.paymentService.cancelPayment(paymentId).isPresent() ? ResponseEntity.accepted().build() : ResponseEntity.notFound().build();
    }

    @ApiOperation(value="Initiate cancellation of payment by it`s ASPSP identifier", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=202, message="ACCEPTED", response=AspspPaymentCancellationResponse.class), @ApiResponse(code=404, message="Payment Not Found")})
    @PostMapping(value={"/{payment-id}/cancel"})
    public ResponseEntity<AspspPaymentCancellationResponse> initiatePaymentCancellation(@PathVariable(value="payment-id") String paymentId) {
        return this.paymentService.initiatePaymentCancellation(paymentId).map(p -> new ResponseEntity(p, HttpStatus.ACCEPTED)).orElseGet(() -> ((ResponseEntity.HeadersBuilder)ResponseEntity.notFound()).build());
    }

    @ConstructorProperties(value={"paymentService"})
    public PaymentController(PaymentService paymentService) {
        this.paymentService = paymentService;
    }
}

