/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.web;

import de.adorsys.aspsp.aspspmockserver.exception.AspspRestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.HandlerMethod;

@RestControllerAdvice
public class AspspGlobalExceptionController {
    private static final Logger log = LoggerFactory.getLogger(AspspGlobalExceptionController.class);

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity exception(Exception ex, HandlerMethod handlerMethod) {
        log.warn("Uncatched exception handled in Controller: {}, message: {}, stackTrace: {}", new Object[]{handlerMethod.getMethod().getDeclaringClass().getSimpleName(), ex.getMessage(), ex});
        return new ResponseEntity((Object)HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase(), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={AspspRestException.class})
    public ResponseEntity aspspRestException(AspspRestException ex, HandlerMethod handlerMethod) {
        log.warn("AspspRestException handled in service: {}, message: {}", (Object)handlerMethod.getMethod().getDeclaringClass().getSimpleName(), (Object)ex.getMessage());
        return new ResponseEntity((Object)ex.getMessage(), ex.getHttpStatus());
    }
}

