/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.web;

import de.adorsys.aspsp.aspspmockserver.domain.Confirmation;
import de.adorsys.aspsp.aspspmockserver.domain.ConfirmationType;
import de.adorsys.aspsp.aspspmockserver.service.ConsentService;
import de.adorsys.aspsp.aspspmockserver.service.TanConfirmationService;
import de.adorsys.psd2.aspsp.mock.api.consent.AspspConsentStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import java.beans.ConstructorProperties;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/consent/confirmation/ais"})
@Api(tags={"Consent confirmation for online banking"}, description="Provides access to consent confirmation for online banking")
public class ConsentConfirmationController {
    private final TanConfirmationService tanConfirmationService;
    private final ConsentService consentService;

    @PostMapping(path={"/{psu-id}"})
    @ApiOperation(value="Generates TAN for ais consent confirmation", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity generateAndSendTan(@PathVariable(value="psu-id") String psuId) {
        return this.tanConfirmationService.generateAndSendTanForPsuById(psuId) ? ResponseEntity.ok().build() : ResponseEntity.badRequest().build();
    }

    @PutMapping
    @ApiOperation(value="Validates TAN for consent confirmation", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad request")})
    public ResponseEntity confirmTan(@RequestBody Confirmation confirmation) {
        return this.tanConfirmationService.confirmTan(confirmation.getPsuId(), confirmation.getTanNumber(), confirmation.getConsentId(), ConfirmationType.CONSENT);
    }

    @PutMapping(path={"/{consent-id}/{status}"})
    @ApiOperation(value="Update ais consent status of the corresponding consent", authorizations={@Authorization(value="oauth2", scopes={@AuthorizationScope(scope="read", description="Access read API")})})
    public ResponseEntity<Void> updateAisConsentStatus(@PathVariable(value="consent-id") String consentId, @PathVariable(value="status") AspspConsentStatus status) {
        this.consentService.updateAisConsentStatus(consentId, status);
        return ResponseEntity.ok().build();
    }

    @ConstructorProperties(value={"tanConfirmationService", "consentService"})
    public ConsentConfirmationController(TanConfirmationService tanConfirmationService, ConsentService consentService) {
        this.tanConfirmationService = tanConfirmationService;
        this.consentService = consentService;
    }
}

