/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.service;

import de.adorsys.aspsp.aspspmockserver.domain.ConfirmationType;
import de.adorsys.aspsp.aspspmockserver.exception.ApiError;
import de.adorsys.aspsp.aspspmockserver.repository.TanRepository;
import de.adorsys.aspsp.aspspmockserver.service.AccountService;
import de.adorsys.aspsp.aspspmockserver.service.ConsentService;
import de.adorsys.aspsp.aspspmockserver.service.PaymentService;
import de.adorsys.psd2.aspsp.mock.api.consent.AspspConsentStatus;
import de.adorsys.psd2.aspsp.mock.api.psu.AspspAuthenticationObject;
import de.adorsys.psd2.aspsp.mock.api.psu.Tan;
import de.adorsys.psd2.aspsp.mock.api.psu.TanStatus;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Service
public class TanConfirmationService {
    private static final Logger log = LoggerFactory.getLogger(TanConfirmationService.class);
    @Value(value="${maximum-number-of-tan-attempts}")
    private int maximumNumberOfTanAttempts;
    private final TanRepository tanRepository;
    private static final String EMAIL_TEMPLATE_PATH = "email/email-template.html";
    private final JavaMailSender emailSender;
    private final Configuration fmConfiguration;
    private final AccountService accountService;
    private final PaymentService paymentService;
    private final ConsentService consentService;

    public boolean sendUserAuthRequestWithPreSelectedScaMethod(String psuId, String authenticationMethodId) {
        return this.accountService.getPsuByPsuId(psuId).map(psu -> {
            Optional<AspspAuthenticationObject> scaMethod = psu.getScaMethods().stream().filter(m -> authenticationMethodId.equals(m.getAuthenticationMethodId())).findFirst();
            if (scaMethod.isPresent()) {
                return this.generateAndSendTanForPsuById(psuId);
            }
            return false;
        }).orElse(false);
    }

    public boolean generateAndSendTanForPsuById(String psuId) {
        return this.accountService.getPsuByPsuId(psuId).map(psu -> this.createAndSendTan(psu.getPsuId(), psu.getEmail())).orElse(false);
    }

    public ResponseEntity confirmTan(String psuId, String tanNumber, String consentId, ConfirmationType confirmationType) {
        if (this.isTanNumberValid(psuId, tanNumber)) {
            return new ResponseEntity(HttpStatus.OK);
        }
        if (this.getTanNumberOfAttempts(psuId) < this.maximumNumberOfTanAttempts) {
            ApiError error = new ApiError(HttpStatus.BAD_REQUEST, "WRONG_TAN", "Bad request");
            return new ResponseEntity((Object)error, error.getStatus());
        }
        this.changeConsentStatusToRejected(consentId, confirmationType);
        ApiError error = new ApiError(HttpStatus.BAD_REQUEST, "LIMIT_EXCEEDED", "Bad request");
        return new ResponseEntity((Object)error, error.getStatus());
    }

    private boolean isTanNumberValid(String psuId, String tanNumber) {
        return this.accountService.getPsuByPsuId(psuId).map(psu -> this.isPsuTanNumberValid(psu.getPsuId(), tanNumber)).orElse(false);
    }

    private int getTanNumberOfAttempts(String psuId) {
        return this.accountService.getPsuByPsuId(psuId).flatMap(psu -> this.tanRepository.findByPsuIdAndTanStatus(psu.getPsuId(), TanStatus.UNUSED).stream().findFirst().map(Tan::getNumberOfAttempts)).orElse(this.maximumNumberOfTanAttempts);
    }

    private boolean isPsuTanNumberValid(String psuId, String tanNumber) {
        return this.tanRepository.findByPsuIdAndTanStatus(psuId, TanStatus.UNUSED).stream().findFirst().map(t -> this.validateTanAndUpdateTanStatus(t, tanNumber)).orElse(false);
    }

    private boolean createAndSendTan(String psuId, String email) {
        this.changeOldTansToInvalid(psuId);
        Tan tan = new Tan(psuId, this.generateTanNumber());
        tan = (Tan)this.tanRepository.save((Object)tan);
        return this.sendTanNumberOnEmail(email, tan.getTanNumber());
    }

    private void changeOldTansToInvalid(String psuId) {
        List tans = this.tanRepository.findByPsuIdAndTanStatus(psuId, TanStatus.UNUSED);
        if (CollectionUtils.isNotEmpty((Collection)tans)) {
            for (Tan oldTan : tans) {
                oldTan.setTanStatus(TanStatus.INVALID);
                oldTan.setNumberOfAttempts(this.maximumNumberOfTanAttempts);
            }
            this.tanRepository.save((Iterable)tans);
        }
    }

    private boolean validateTanAndUpdateTanStatus(Tan originalTan, String givenTanNumber) {
        boolean isTanValid = originalTan.getTanNumber().equals(givenTanNumber);
        if (isTanValid) {
            originalTan.setTanStatus(TanStatus.VALID);
        } else {
            if (originalTan.getNumberOfAttempts() == this.maximumNumberOfTanAttempts - 1) {
                originalTan.setTanStatus(TanStatus.INVALID);
            }
            originalTan.incrementNumberOfAttempts();
        }
        this.tanRepository.save((Object)originalTan);
        return isTanValid;
    }

    private String generateTanNumber() {
        return RandomStringUtils.random((int)6, (boolean)true, (boolean)true);
    }

    private boolean sendTanNumberOnEmail(String email, String tanNumber) {
        if (this.emailSender == null) {
            log.warn("Email properties has not been set");
            return false;
        }
        MimeMessage mimeMessage = this.emailSender.createMimeMessage();
        try {
            MimeMessageHelper mail = new MimeMessageHelper(mimeMessage, true);
            mail.setSubject("Your TAN for payment confirmation");
            mail.setFrom(email);
            mail.setTo(email);
            mail.setText(this.getEmailContentFromTemplate(tanNumber), true);
            this.emailSender.send(mail.getMimeMessage());
            log.info("Generated Tan: {}", (Object)tanNumber);
            return true;
        }
        catch (MessagingException e) {
            log.warn("Problem with creating or sanding email: {}", (Throwable)e);
            return false;
        }
    }

    private String getEmailContentFromTemplate(String tanNumber) {
        StringBuilder content = new StringBuilder();
        try {
            Template emailTemplate = this.fmConfiguration.getTemplate(EMAIL_TEMPLATE_PATH);
            content.append(FreeMarkerTemplateUtils.processTemplateIntoString((Template)emailTemplate, Collections.singletonMap("tan", tanNumber)));
        }
        catch (Exception e) {
            log.warn("Problem with reading email template : {}", (Throwable)e);
            return "Your TAN number is " + tanNumber;
        }
        return content.toString();
    }

    private void changeConsentStatusToRejected(String consentId, ConfirmationType confirmationType) {
        if (confirmationType == ConfirmationType.PAYMENT) {
            this.paymentService.updatePaymentConsentStatus(consentId, AspspConsentStatus.REJECTED);
        } else {
            this.consentService.updateAisConsentStatus(consentId, AspspConsentStatus.REJECTED);
        }
    }

    @ConstructorProperties(value={"tanRepository", "emailSender", "fmConfiguration", "accountService", "paymentService", "consentService"})
    public TanConfirmationService(TanRepository tanRepository, JavaMailSender emailSender, Configuration fmConfiguration, AccountService accountService, PaymentService paymentService, ConsentService consentService) {
        this.tanRepository = tanRepository;
        this.emailSender = emailSender;
        this.fmConfiguration = fmConfiguration;
        this.accountService = accountService;
        this.paymentService = paymentService;
        this.consentService = consentService;
    }
}

