/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.service;

import de.adorsys.aspsp.aspspmockserver.config.rest.consent.PisConsentRemoteUrls;
import de.adorsys.aspsp.aspspmockserver.domain.pis.AspspPayment;
import de.adorsys.aspsp.aspspmockserver.domain.pis.PisPaymentType;
import de.adorsys.aspsp.aspspmockserver.repository.PaymentRepository;
import de.adorsys.aspsp.aspspmockserver.service.AccountService;
import de.adorsys.aspsp.aspspmockserver.service.mapper.PaymentMapper;
import de.adorsys.psd2.aspsp.mock.api.account.AspspAccountBalance;
import de.adorsys.psd2.aspsp.mock.api.account.AspspAccountDetails;
import de.adorsys.psd2.aspsp.mock.api.account.AspspAccountReference;
import de.adorsys.psd2.aspsp.mock.api.common.AspspAmount;
import de.adorsys.psd2.aspsp.mock.api.common.AspspTransactionStatus;
import de.adorsys.psd2.aspsp.mock.api.consent.AspspConsentStatus;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspBulkPayment;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspPaymentCancellationResponse;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspPeriodicPayment;
import de.adorsys.psd2.aspsp.mock.api.payment.AspspSinglePayment;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentService.class);
    private final PaymentRepository paymentRepository;
    @Qualifier(value="consentRestTemplate")
    private final RestTemplate consentRestTemplate;
    private final PisConsentRemoteUrls remotePisConsentUrls;
    private final PaymentMapper paymentMapper;
    private final AccountService accountService;

    public Optional<AspspSinglePayment> addPayment(@NotNull AspspSinglePayment payment) {
        if (payment.getInstructedAmount() != null && this.areFundsSufficient(payment.getDebtorAccount(), payment.getInstructedAmount().getAmount())) {
            AspspPayment saved = (AspspPayment)this.paymentRepository.save((Object)this.paymentMapper.mapToAspspPayment(payment, PisPaymentType.SINGLE));
            return Optional.ofNullable(this.paymentMapper.mapToAspspSinglePayment(saved));
        }
        log.warn("Insufficient funds for paying {} on account {}", (Object)payment.getInstructedAmount(), (Object)payment.getDebtorAccount());
        return Optional.empty();
    }

    public Optional<AspspPeriodicPayment> addPeriodicPayment(@NotNull AspspPeriodicPayment payment) {
        AspspPayment saved = (AspspPayment)this.paymentRepository.save((Object)this.paymentMapper.mapToAspspPayment(payment, PisPaymentType.PERIODIC));
        return Optional.ofNullable(this.paymentMapper.mapToAspspPeriodicPayment(saved));
    }

    public boolean isPaymentExist(String paymentId) {
        return this.paymentRepository.exists((Serializable)((Object)paymentId));
    }

    public Optional<AspspTransactionStatus> getPaymentStatusById(String paymentId) {
        List payments = this.paymentRepository.findByPaymentIdOrBulkId(paymentId, paymentId);
        return payments.isEmpty() ? Optional.empty() : Optional.of(((AspspPayment)payments.get(0)).getPaymentStatus());
    }

    public Optional<AspspBulkPayment> addBulkPayments(AspspBulkPayment payments) {
        BigDecimal totalAmount;
        String bulkId = StringUtils.isBlank((CharSequence)payments.getPaymentId()) ? UUID.randomUUID().toString() : payments.getPaymentId();
        List aspspPayments = this.paymentMapper.mapToAspspPaymentList(payments.getPayments(), bulkId);
        Optional<AspspPayment> firstInvalid = aspspPayments.stream().filter(arg_0 -> this.isNonExistingAccount(arg_0)).findFirst();
        if (firstInvalid.isPresent()) {
            return Optional.empty();
        }
        AspspAccountReference debtorAccount = this.getDebtorAccountFromPayments(aspspPayments);
        if (!this.areFundsSufficient(debtorAccount, totalAmount = this.calculateTotalAmount(aspspPayments))) {
            log.warn("Insufficient funds for paying {} on account {}", (Object)totalAmount, (Object)debtorAccount);
            return Optional.empty();
        }
        List savedPayments = this.paymentRepository.save((Iterable)aspspPayments);
        AspspBulkPayment result = new AspspBulkPayment();
        result.setPayments(this.paymentMapper.mapToAspspSinglePaymentList(savedPayments));
        result.setPaymentId(((AspspPayment)savedPayments.get(0)).getBulkId());
        return Optional.of(result);
    }

    private AspspAccountReference getDebtorAccountFromPayments(List<AspspPayment> aspspPayments) {
        return aspspPayments.stream().findFirst().map(AspspPayment::getDebtorAccount).orElse(null);
    }

    private BigDecimal calculateTotalAmount(List<AspspPayment> payments) {
        return payments.stream().map(arg_0 -> this.getAmountFromPayment(arg_0)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private boolean isNonExistingAccount(AspspPayment p) {
        String debtorAccountIdFromPayment = this.getDebtorAccountIdFromPayment(p);
        return !this.accountService.getPsuIdByIban(debtorAccountIdFromPayment).isPresent();
    }

    BigDecimal calculateAmountToBeCharged(String accountId) {
        return this.paymentRepository.findAll().stream().filter(paym -> this.getDebtorAccountIdFromPayment(paym).equals(accountId)).map(arg_0 -> this.getAmountFromPayment(arg_0)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public void updatePaymentConsentStatus(@NotNull String consentId, AspspConsentStatus consentStatus) {
        this.consentRestTemplate.put(this.remotePisConsentUrls.updatePisConsentStatus(), null, new Object[]{consentId, consentStatus.name()});
    }

    public List<AspspPayment> getPaymentById(String paymentId) {
        return this.paymentRepository.findByPaymentIdOrBulkId(paymentId, paymentId);
    }

    public Optional<AspspPaymentCancellationResponse> cancelPayment(String paymentId) {
        List payments = this.paymentRepository.findByPaymentIdOrBulkId(paymentId, paymentId);
        if (CollectionUtils.isEmpty((Collection)payments)) {
            return Optional.empty();
        }
        payments.forEach(payment -> this.updateAspsPaymentStatus(payment, AspspTransactionStatus.CANC));
        return Optional.of(this.getPaymentCancellationResponse(false, AspspTransactionStatus.CANC));
    }

    public Optional<AspspPaymentCancellationResponse> initiatePaymentCancellation(String paymentId) {
        List payments = this.paymentRepository.findByPaymentIdOrBulkId(paymentId, paymentId);
        if (CollectionUtils.isEmpty((Collection)payments)) {
            return Optional.empty();
        }
        payments.forEach(payment -> this.updateAspsPaymentStatus(payment, AspspTransactionStatus.ACTC));
        return Optional.of(this.getPaymentCancellationResponse(true, AspspTransactionStatus.ACTC));
    }

    public List<AspspPayment> getAllPayments() {
        return this.paymentRepository.findAll();
    }

    private AspspPayment updateAspsPaymentStatus(AspspPayment payment, AspspTransactionStatus transactionStatus) {
        payment.setPaymentStatus(transactionStatus);
        return (AspspPayment)this.paymentRepository.save((Object)payment);
    }

    private AspspPaymentCancellationResponse getPaymentCancellationResponse(boolean cancellationAuthorisationMandated, AspspTransactionStatus transactionStatus) {
        AspspPaymentCancellationResponse response = new AspspPaymentCancellationResponse();
        response.setCancellationAuthorisationMandated(cancellationAuthorisationMandated);
        response.setTransactionStatus(transactionStatus);
        return response;
    }

    private boolean areFundsSufficient(AspspAccountReference reference, BigDecimal amount) {
        return Optional.ofNullable(reference).map(arg_0 -> this.getAvailableBalanceByReference(arg_0)).map(am -> am.compareTo(amount) >= 0).orElse(false);
    }

    private BigDecimal getAvailableBalanceByReference(AspspAccountReference reference) {
        BigDecimal amountZero = BigDecimal.ZERO;
        List accounts = this.accountService.getAccountsByIban(reference.getIban());
        if (CollectionUtils.isNotEmpty((Collection)accounts)) {
            return accounts.stream().filter(ac -> ac.getCurrency() == reference.getCurrency()).findFirst().flatMap(AspspAccountDetails::getFirstBalance).map(AspspAccountBalance::getSpiBalanceAmount).map(AspspAmount::getAmount).orElse(amountZero);
        }
        return amountZero;
    }

    private String getDebtorAccountIdFromPayment(AspspPayment aspspPayment) {
        return Optional.ofNullable(aspspPayment.getDebtorAccount()).map(AspspAccountReference::getIban).orElse("");
    }

    private BigDecimal getAmountFromPayment(AspspPayment aspspPayment) {
        return Optional.ofNullable(aspspPayment).map(paym -> this.getContentFromAmount(paym.getInstructedAmount())).orElse(BigDecimal.ZERO);
    }

    private BigDecimal getContentFromAmount(AspspAmount amount) {
        return Optional.ofNullable(amount).map(AspspAmount::getAmount).orElse(BigDecimal.ZERO);
    }

    @ConstructorProperties(value={"paymentRepository", "consentRestTemplate", "remotePisConsentUrls", "paymentMapper", "accountService"})
    public PaymentService(PaymentRepository paymentRepository, RestTemplate consentRestTemplate, PisConsentRemoteUrls remotePisConsentUrls, PaymentMapper paymentMapper, AccountService accountService) {
        this.paymentRepository = paymentRepository;
        this.consentRestTemplate = consentRestTemplate;
        this.remotePisConsentUrls = remotePisConsentUrls;
        this.paymentMapper = paymentMapper;
        this.accountService = accountService;
    }
}

