/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.aspspmockserver.domain.pis.proto;

import de.adorsys.aspsp.aspspmockserver.domain.TppInfo;
import de.adorsys.aspsp.aspspmockserver.domain.pis.PisPayment;
import de.adorsys.aspsp.aspspmockserver.domain.pis.PisPaymentProduct;
import de.adorsys.aspsp.aspspmockserver.domain.pis.PisPaymentType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.List;

@ApiModel(description="Pis payment initialisation consent request", value="PisConsentRequest")
public class PisConsentRequest {
    @ApiModelProperty(value="Payment data", required=true)
    private List<PisPayment> payments;
    @ApiModelProperty(value="Payment product", required=true, example="sepa-credit-transfers")
    private PisPaymentProduct paymentProduct;
    @ApiModelProperty(value="Payment type: BULK, SINGLE or PERIODIC.", required=true, example="SINGLE")
    private PisPaymentType paymentType;
    @ApiModelProperty(value="Tpp information", required=true)
    private TppInfo tppInfo;
    @ApiModelProperty(value="ASPSP consent data", example="zzzzzzzz")
    private byte[] aspspConsentData;

    public List<PisPayment> getPayments() {
        return this.payments;
    }

    public PisPaymentProduct getPaymentProduct() {
        return this.paymentProduct;
    }

    public PisPaymentType getPaymentType() {
        return this.paymentType;
    }

    public TppInfo getTppInfo() {
        return this.tppInfo;
    }

    public byte[] getAspspConsentData() {
        return this.aspspConsentData;
    }

    public void setPayments(List<PisPayment> payments) {
        this.payments = payments;
    }

    public void setPaymentProduct(PisPaymentProduct paymentProduct) {
        this.paymentProduct = paymentProduct;
    }

    public void setPaymentType(PisPaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public void setTppInfo(TppInfo tppInfo) {
        this.tppInfo = tppInfo;
    }

    public void setAspspConsentData(byte[] aspspConsentData) {
        this.aspspConsentData = aspspConsentData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PisConsentRequest)) {
            return false;
        }
        PisConsentRequest other = (PisConsentRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List this$payments = this.getPayments();
        List other$payments = other.getPayments();
        if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
            return false;
        }
        PisPaymentProduct this$paymentProduct = this.getPaymentProduct();
        PisPaymentProduct other$paymentProduct = other.getPaymentProduct();
        if (this$paymentProduct == null ? other$paymentProduct != null : !this$paymentProduct.equals(other$paymentProduct)) {
            return false;
        }
        PisPaymentType this$paymentType = this.getPaymentType();
        PisPaymentType other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !this$paymentType.equals(other$paymentType)) {
            return false;
        }
        TppInfo this$tppInfo = this.getTppInfo();
        TppInfo other$tppInfo = other.getTppInfo();
        if (this$tppInfo == null ? other$tppInfo != null : !this$tppInfo.equals(other$tppInfo)) {
            return false;
        }
        return Arrays.equals(this.getAspspConsentData(), other.getAspspConsentData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof PisConsentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List $payments = this.getPayments();
        result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
        PisPaymentProduct $paymentProduct = this.getPaymentProduct();
        result = result * 59 + ($paymentProduct == null ? 43 : $paymentProduct.hashCode());
        PisPaymentType $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : $paymentType.hashCode());
        TppInfo $tppInfo = this.getTppInfo();
        result = result * 59 + ($tppInfo == null ? 43 : $tppInfo.hashCode());
        result = result * 59 + Arrays.hashCode(this.getAspspConsentData());
        return result;
    }

    public String toString() {
        return "PisConsentRequest(payments=" + this.getPayments() + ", paymentProduct=" + this.getPaymentProduct() + ", paymentType=" + this.getPaymentType() + ", tppInfo=" + this.getTppInfo() + ", aspspConsentData=" + Arrays.toString(this.getAspspConsentData()) + ")";
    }
}

