/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.validator.certificate.util;

import com.nimbusds.jose.util.X509CertUtils;
import de.adorsys.psd2.validator.certificate.CertificateErrorMsgCode;
import de.adorsys.psd2.validator.certificate.util.TppCertificateData;
import de.adorsys.psd2.validator.certificate.util.TppRole;
import de.adorsys.psd2.validator.common.PSD2QCStatement;
import de.adorsys.psd2.validator.common.PSD2QCType;
import de.adorsys.psd2.validator.common.RoleOfPSP;
import de.adorsys.psd2.validator.common.RolesOfPSP;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import no.difi.certvalidator.api.CertificateValidationException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateExtractorUtil {
    private static final Logger log = LoggerFactory.getLogger(CertificateExtractorUtil.class);

    public static TppCertificateData extract(String encodedCert) throws CertificateValidationException {
        RoleOfPSP[] roles2;
        X509Certificate cert = X509CertUtils.parse((String)encodedCert);
        ArrayList<TppRole> roles = new ArrayList<TppRole>();
        TppCertificateData tppCertData = new TppCertificateData();
        PSD2QCType psd2qcType = PSD2QCStatement.psd2QCType(cert);
        RolesOfPSP rolesOfPSP = psd2qcType.getRolesOfPSP();
        for (RoleOfPSP roleOfPSP : roles2 = rolesOfPSP.getRoles()) {
            roles.add(TppRole.valueOf(roleOfPSP.getNormalizedRoleName()));
        }
        tppCertData.setPspRoles(roles);
        tppCertData.setPspAuthorityName(psd2qcType.getnCAName().getString());
        tppCertData.setPspAuthorityId(psd2qcType.getnCAId().getString());
        try {
            X500Name x500name = new JcaX509CertificateHolder(cert).getSubject();
            String pspAuthorisationNber = IETFUtils.valueToString((ASN1Encodable)x500name.getRDNs(BCStyle.ORGANIZATION_IDENTIFIER)[0].getFirst().getValue());
            tppCertData.setPspAuthorizationNumber(pspAuthorisationNber);
            String pspName = IETFUtils.valueToString((ASN1Encodable)x500name.getRDNs(BCStyle.CN)[0].getFirst().getValue());
            tppCertData.setPspName(pspName);
        }
        catch (CertificateEncodingException e) {
            log.debug(e.getMessage());
            throw new CertificateValidationException(CertificateErrorMsgCode.CERTIFICATE_INVALID.toString());
        }
        return tppCertData;
    }
}

