/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.xs2a.testsandbox.internal;

import de.adorsys.opba.protocol.xs2a.testsandbox.internal.SandboxApp;
import de.adorsys.opba.protocol.xs2a.testsandbox.internal.SandboxAppExecutor;
import de.adorsys.opba.protocol.xs2a.testsandbox.internal.StarterContext;
import java.beans.ConstructorProperties;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.ThreadFactory;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SandboxAppsThreadFactory
implements ThreadFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SandboxAppsThreadFactory.class);
    private final StarterContext ctx;

    @Override
    public Thread newThread(@NotNull Runnable runnable) {
        return new ClassLoaderCapturingThread(runnable, this.ctx);
    }

    @ConstructorProperties(value={"ctx"})
    @Generated
    public SandboxAppsThreadFactory(StarterContext ctx) {
        this.ctx = ctx;
    }

    public static class ClassLoaderCapturingThread
    extends Thread {
        private final SandboxApp app;
        private final StarterContext ctx;

        ClassLoaderCapturingThread(Runnable runnable, StarterContext ctx) {
            super(runnable);
            this.app = this.computeApp(runnable);
            this.ctx = ctx;
        }

        @Override
        public void setContextClassLoader(ClassLoader loader) {
            if (null == loader) {
                return;
            }
            this.ctx.getLoader().put(this.app, loader);
            this.disableTomcatWar(loader);
            super.setContextClassLoader(new URLClassLoader(new URL[0], loader));
        }

        private SandboxApp computeApp(Runnable runnable) {
            Field f = runnable.getClass().getDeclaredField("firstTask");
            f.setAccessible(true);
            return ((SandboxAppExecutor.TaggedFuture)f.get(runnable)).getApp();
        }

        private void disableTomcatWar(ClassLoader loader) {
            try {
                Class<?> cls = loader.loadClass("org.apache.catalina.webresources.TomcatURLStreamHandlerFactory");
                Method disable = cls.getDeclaredMethod("disable", new Class[0]);
                disable.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException ex) {
                log.info("Looks like tomcat is not present", (Throwable)ex);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                log.error("Failed disabling tomcat", (Throwable)ex);
            }
        }
    }
}

