/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.xs2a.testsandbox.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import de.adorsys.opba.protocol.xs2a.testsandbox.internal.StarterContext;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.util.Strings;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;

public enum SandboxApp {
    ONLINE_BANKING_UI("adorsys/xs2a-online-banking-ui:2.9", true),
    LEDGERS_APP("ledgers-app-2.8.jar"),
    LEDGERS_GATEWAY("gateway-app-5.10.jar", false, (Set<SandboxApp>)ImmutableSet.of((Object)((Object)ONLINE_BANKING_UI), (Object)((Object)LEDGERS_APP))),
    ASPSP_PROFILE("aspsp-profile-server-5.10-exec.jar"),
    CONSENT_MGMT("cms-standalone-service-5.10.jar"),
    ONLINE_BANKING("online-banking-app-2.9.jar", false, (Set<SandboxApp>)ImmutableSet.of((Object)((Object)ONLINE_BANKING_UI), (Object)((Object)LEDGERS_APP))),
    TPP_REST("tpp-rest-server-2.9.jar", false, (Set<SandboxApp>)ImmutableSet.of((Object)((Object)ONLINE_BANKING_UI), (Object)((Object)LEDGERS_APP))),
    CERT_GENERATOR("certificate-generator-2.9.jar");

    @Generated
    private static final Logger log;
    public static final String SANDBOX_LOG_LEVEL = "SANDBOX_LOG_LEVEL";
    public static final String DB_TYPE = "DB_TYPE";
    public static final String TEST_CONTAINERS_POSTGRES = "test-containers-postgres";
    private static final Pattern REFERENCE_PATTERN;
    private static final Pattern PORT_PATTERN;
    private static final Map<String, String> EXPOSED_VARIABLES;
    private static final ObjectMapper YML;
    private final boolean dockerized;
    private final String jarOrDockerFile;
    private final String mainClass;
    private final Set<SandboxApp> dependsOn;

    private SandboxApp(String jarOrDockerFile) {
        this.jarOrDockerFile = jarOrDockerFile;
        this.mainClass = null;
        this.dockerized = false;
        this.dependsOn = null;
    }

    private SandboxApp(String jarOrDockerFile, String mainClass) {
        this.jarOrDockerFile = jarOrDockerFile;
        this.mainClass = mainClass;
        this.dockerized = false;
        this.dependsOn = null;
    }

    private SandboxApp(String jarOrDockerImage, boolean dockerized) {
        this.jarOrDockerFile = jarOrDockerImage;
        this.mainClass = null;
        this.dockerized = dockerized;
        this.dependsOn = null;
    }

    private SandboxApp(String jarOrDockerImage, boolean dockerized, Set<SandboxApp> dependsOn) {
        this.jarOrDockerFile = jarOrDockerImage;
        this.mainClass = null;
        this.dockerized = dockerized;
        this.dependsOn = dependsOn;
    }

    public Runnable runnable(StarterContext ctx) {
        return new SandboxRunnable(this, () -> this.doRun(ctx));
    }

    public boolean isReadyToUse(StarterContext ctx) {
        String pointer;
        Integer portIfDockerized = ctx.getDockerPorts().get((Object)this);
        if (null != portIfDockerized) {
            return this.portIsListening(portIfDockerized);
        }
        if (this.isDockerized()) {
            return false;
        }
        JsonNode tree = YML.readTree(Resources.getResource((String)"sandbox-old/application-test-common.yml"));
        JsonNode port = tree.at(pointer = "/common/apps/local/" + this.name().toLowerCase().replaceAll("_", "") + "/port");
        if (!port.isInt()) {
            throw new IllegalStateException("Port for " + pointer + " should be specified");
        }
        return this.portIsListening(port.asInt());
    }

    public static boolean allReadyToUse(StarterContext ctx) {
        return (long)SandboxApp.values().length == SandboxApp.countReadyToUse(ctx);
    }

    public static long countReadyToUse(StarterContext ctx) {
        return Arrays.stream(SandboxApp.values()).map(it -> it.isReadyToUse(ctx)).filter(it -> it).count();
    }

    Method getMainEntryPoint(ClassloaderWithJar classloaderWithJar) {
        String jarPath = classloaderWithJar.getJarPath();
        URLClassLoader loader = classloaderWithJar.getLoader();
        Class<?> cls = loader.loadClass(this.getMainClass(jarPath));
        return cls.getDeclaredMethod("main", String[].class);
    }

    String getMainClass(String jarPath) {
        if (null != this.mainClass) {
            return this.mainClass;
        }
        JarFile jarFile = new JarFile(jarPath);
        Manifest manifest = jarFile.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        return attributes.getValue(Attributes.Name.MAIN_CLASS);
    }

    private boolean portIsListening(int port) {
        boolean bl;
        Socket ignored = new Socket("localhost", port);
        try {
            URL url = new URL("http://localhost:" + port);
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            int statusCode = http.getResponseCode();
            bl = statusCode >= HttpStatus.OK.value();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ignored2) {
                return false;
            }
        }
        ignored.close();
        return bl;
    }

    private void doRun(StarterContext ctx) {
        String oldName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.name());
        try {
            log.info("Starting {}", (Object)this.name());
            if (null != this.dependsOn) {
                this.dependsOn.forEach(it -> Awaitility.await().atMost(Durations.FIVE_MINUTES).pollDelay(Durations.ONE_SECOND).until(() -> it.isReadyToUse(ctx)));
            }
            if (this.dockerized) {
                this.doRunDocker(ctx);
            } else {
                this.doRunJar(ctx);
            }
        }
        finally {
            Thread.currentThread().setName(oldName);
        }
    }

    private void doRunDocker(StarterContext ctx) {
        try {
            HashMap envVars = new HashMap();
            JsonNode commonConfig = YML.readTree(Resources.getResource((String)"sandbox-old/application-test-common.yml"));
            String pointer = "/env";
            JsonNode appConfig = YML.readTree(Resources.getResource((String)("sandbox-old/application-" + this.testProfileName() + ".yml")));
            JsonNode declaredVars = appConfig.at(pointer);
            declaredVars.fields().forEachRemaining(entry -> this.readYamlVariableToMap((Map.Entry<String, JsonNode>)entry, commonConfig, envVars));
            FixedHostPortGenericContainer container = new FixedHostPortGenericContainer(this.jarOrDockerFile);
            int containerPort = Integer.parseInt(this.readVariableFromConfig(appConfig.at("/port"), commonConfig));
            if (System.getProperty("os.name").toLowerCase().contains("linux")) {
                container.withExtraHost("host.docker.internal", new InetSocketAddress(0).getAddress().getHostAddress());
                container.withNetworkMode("host");
            } else {
                container.withFixedExposedPort(containerPort, containerPort);
            }
            container.withEnv(envVars).waitingFor(Wait.defaultWaitStrategy());
            container.start();
            ctx.getDockerContainer().put(this, (GenericContainer)container);
            ctx.getDockerPorts().put(this, containerPort);
        }
        catch (IOException | RuntimeException ex) {
            log.error("{} from {} Dockerfile has terminated exceptionally", new Object[]{this.name(), this.jarOrDockerFile, ex});
        }
    }

    private void readYamlVariableToMap(Map.Entry<String, JsonNode> entry, JsonNode configSource, Map<String, String> envVars) {
        envVars.put(entry.getKey(), this.readVariableFromConfig(entry.getValue(), configSource));
    }

    private boolean hasReference(JsonNode entry) {
        return entry.isTextual() && entry.textValue().contains("${") && entry.textValue().contains("}");
    }

    private String readVariableFromConfig(JsonNode value, JsonNode configSource) {
        if (!this.hasReference(value)) {
            return value.asText();
        }
        String toParse = value.textValue();
        String result = value.textValue();
        Matcher matcher = REFERENCE_PATTERN.matcher(toParse);
        while (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String foundValue;
                String variableName = matcher.group(i);
                if (EXPOSED_VARIABLES.containsKey(variableName)) {
                    foundValue = EXPOSED_VARIABLES.get(variableName);
                } else {
                    String path = variableName.replaceAll("\\.", "/");
                    foundValue = this.readVariableFromConfig(configSource.at("/" + path), configSource);
                }
                result = result.replaceAll(Pattern.quote("${" + variableName + "}"), foundValue);
            }
        }
        return result;
    }

    private void doRunJar(StarterContext ctx) {
        try {
            ClassloaderWithJar classloaderWithJar = new ClassloaderWithJar(this.jarOrDockerFile);
            this.buildSpringConfigLocation(ctx);
            this.getMainEntryPoint(classloaderWithJar).invoke(null, new Object[]{new String[]{"--spring.profiles.include=" + Joiner.on((String)",").join(this.activeProfilesForTest()), "--spring.config.location=" + this.buildSpringConfigLocation(ctx), "--primary.profile=" + this.getPrimaryConfigFile(), "--testcontainers.postgres.port=" + ctx.getDbPort().get(), "--logging.level.root=" + SandboxApp.getSandboxLogLevel(), "--feign.client.config.default.loggerLevel=NONE"}});
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            log.error("Failed to invoke main() method for {} of {}", new Object[]{this.name(), this.jarOrDockerFile, ex});
        }
        catch (RuntimeException ex) {
            log.error("{} from {} jar has terminated exceptionally", new Object[]{this.name(), this.jarOrDockerFile, ex});
        }
    }

    private Set<String> activeProfilesForTest() {
        return Sets.union((Set)ImmutableSet.of((Object)SandboxApp.getDbProfile()), this.defaultProfiles());
    }

    private String buildSpringConfigLocation(StarterContext ctx) {
        return Joiner.on((String)",").join((Object)"classpath:/", (Object)this.getAndValidatePathFromResource("sandbox-old/application-" + SandboxApp.dbProfileAndStartDbIfNeeded(ctx) + ".yml"), new Object[]{this.getAndValidatePathFromResource("sandbox-old/application-test-common.yml"), this.getPrimaryConfigFile()});
    }

    private String getPrimaryConfigFile() {
        return this.getAndValidatePathFromResource("sandbox-old/application-" + this.testProfileName() + ".yml");
    }

    private String getAndValidatePathFromResource(String resource) {
        URI path = Resources.getResource((String)resource).toURI();
        if (!Paths.get(path).toFile().exists()) {
            throw new IllegalStateException("Profile path " + resource + " does not exist");
        }
        return path.toASCIIString();
    }

    private Set<String> defaultProfiles() {
        ImmutableSet basicProfiles = ImmutableSet.of((Object)"test-common", (Object)this.testProfileName());
        Set<String> extraProfiles = this.extraProfiles();
        return Sets.union((Set)basicProfiles, extraProfiles);
    }

    private String testProfileName() {
        return "test-" + this.name().toLowerCase().replaceAll("_", "-");
    }

    public Set<String> extraProfiles() {
        JsonNode tree = YML.readTree(Resources.getResource((String)("sandbox-old/application-" + this.testProfileName() + ".yml")));
        String pointer = "/spring/profiles/active";
        JsonNode activeProfiles = tree.at(pointer);
        return Arrays.stream(activeProfiles.asText("").split(",")).filter(Strings::isNotBlank).collect(Collectors.toSet());
    }

    private static String dbProfileAndStartDbIfNeeded(StarterContext ctx) {
        String profile = SandboxApp.getDbProfile();
        if (TEST_CONTAINERS_POSTGRES.equals(SandboxApp.getDbType())) {
            SandboxApp.startContainerizedPostgresAndPopulateIt(ctx);
        }
        return profile;
    }

    private static String getDbProfile() {
        String prefix = "test-db-";
        String value = SandboxApp.getDbType();
        return prefix + value.toLowerCase().replaceAll("_", "-");
    }

    private static String getDbType() {
        String value = System.getProperty(DB_TYPE, System.getenv(DB_TYPE));
        if (null != value) {
            return value;
        }
        return TEST_CONTAINERS_POSTGRES;
    }

    private static void startContainerizedPostgresAndPopulateIt(StarterContext ctx) {
        ctx.getDbPort().getAndUpdate(currentPort -> {
            Integer n;
            block9: {
                if (null != currentPort) {
                    return currentPort;
                }
                Connection conn = DriverManager.getConnection("jdbc:tc:postgresql:12:////sandbox_apps?TC_TMPFS=/testtmpfs:rw&TC_DAEMON=true&TC_INITSCRIPT=sandbox/prepare-postgres.sql");
                try {
                    Matcher port = PORT_PATTERN.matcher(conn.getMetaData().getURL());
                    port.matches();
                    n = Integer.valueOf(port.group(1));
                    if (conn == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                conn.close();
            }
            return n;
        });
    }

    private static String getSandboxLogLevel() {
        String level = System.getenv(SANDBOX_LOG_LEVEL);
        if (null == level) {
            return "WARN";
        }
        return level;
    }

    @Generated
    public boolean isDockerized() {
        return this.dockerized;
    }

    @Generated
    public String getJarOrDockerFile() {
        return this.jarOrDockerFile;
    }

    @Generated
    public String getMainClass() {
        return this.mainClass;
    }

    @Generated
    public Set<SandboxApp> getDependsOn() {
        return this.dependsOn;
    }

    static {
        log = LoggerFactory.getLogger(SandboxApp.class);
        REFERENCE_PATTERN = Pattern.compile("\\$\\{([a-zA-Z0-9.]+)}");
        PORT_PATTERN = Pattern.compile("^.+:([0-9]+)/.+$");
        EXPOSED_VARIABLES = ImmutableMap.of((Object)"dockerHost", (Object)"host.docker.internal");
        YML = new ObjectMapper((JsonFactory)new YAMLFactory());
    }

    static class SandboxRunnable
    implements Runnable {
        private final SandboxApp app;
        private final Runnable toRun;

        @Override
        public void run() {
            this.toRun.run();
        }

        @ConstructorProperties(value={"app", "toRun"})
        @Generated
        public SandboxRunnable(SandboxApp app, Runnable toRun) {
            this.app = app;
            this.toRun = toRun;
        }

        @Generated
        public SandboxApp getApp() {
            return this.app;
        }

        @Generated
        public Runnable getToRun() {
            return this.toRun;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SandboxRunnable)) {
                return false;
            }
            SandboxRunnable other = (SandboxRunnable)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SandboxApp this$app = this.getApp();
            SandboxApp other$app = other.getApp();
            if (this$app == null ? other$app != null : !((Object)((Object)this$app)).equals((Object)other$app)) {
                return false;
            }
            Runnable this$toRun = this.getToRun();
            Runnable other$toRun = other.getToRun();
            return !(this$toRun == null ? other$toRun != null : !this$toRun.equals(other$toRun));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SandboxRunnable;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SandboxApp $app = this.getApp();
            result = result * 59 + ($app == null ? 43 : ((Object)((Object)$app)).hashCode());
            Runnable $toRun = this.getToRun();
            result = result * 59 + ($toRun == null ? 43 : $toRun.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SandboxApp.SandboxRunnable(app=" + this.getApp() + ", toRun=" + this.getToRun() + ")";
        }
    }

    private static class ClassloaderWithJar {
        private final String jarPath = Arrays.stream(System.getProperty("java.class.path").split(System.getProperty("path.separator"))).filter(it -> it.endsWith(jar)).findAny().orElseThrow(() -> new IllegalStateException("Jar " + jar + " not found on classpath: " + System.getProperty("java.class.path")));
        private final URLClassLoader loader = new URLClassLoader(new URL[]{Paths.get(this.jarPath, new String[0]).toUri().toURL()}, null);

        ClassloaderWithJar(String jar) {
        }

        @Generated
        public String getJarPath() {
            return this.jarPath;
        }

        @Generated
        public URLClassLoader getLoader() {
            return this.loader;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassloaderWithJar)) {
                return false;
            }
            ClassloaderWithJar other = (ClassloaderWithJar)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$jarPath = this.getJarPath();
            String other$jarPath = other.getJarPath();
            if (this$jarPath == null ? other$jarPath != null : !this$jarPath.equals(other$jarPath)) {
                return false;
            }
            URLClassLoader this$loader = this.getLoader();
            URLClassLoader other$loader = other.getLoader();
            return !(this$loader == null ? other$loader != null : !this$loader.equals(other$loader));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClassloaderWithJar;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jarPath = this.getJarPath();
            result = result * 59 + ($jarPath == null ? 43 : $jarPath.hashCode());
            URLClassLoader $loader = this.getLoader();
            result = result * 59 + ($loader == null ? 43 : $loader.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SandboxApp.ClassloaderWithJar(jarPath=" + this.getJarPath() + ", loader=" + this.getLoader() + ")";
        }
    }
}

