/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.xs2a.testsandbox;

import com.google.common.collect.ImmutableSet;
import de.adorsys.opba.protocol.xs2a.testsandbox.internal.SandboxApp;
import de.adorsys.opba.protocol.xs2a.testsandbox.internal.SandboxAppExecutor;
import de.adorsys.opba.protocol.xs2a.testsandbox.internal.StarterContext;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SandboxAppsStarter
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SandboxAppsStarter.class);
    public static final Set<SandboxApp> ALL = ImmutableSet.copyOf((Object[])SandboxApp.values());
    private final ExecutorService executor;
    private final AtomicBoolean started = new AtomicBoolean();
    private final StarterContext context = new StarterContext();

    public SandboxAppsStarter() {
        this.executor = new SandboxAppExecutor(this.context);
    }

    public SandboxAppsStarter(Map<SandboxApp, Integer> dockerPorts) {
        this.context.getDockerPorts().putAll(dockerPorts);
        this.executor = new SandboxAppExecutor(this.context);
    }

    public StarterContext run(Set<SandboxApp> apps) {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Sandbox is already started");
        }
        apps.forEach(it -> this.executor.submit(it.runnable(this.context)));
        return this.context;
    }

    public StarterContext runAll() {
        this.run(ALL);
        return this.context;
    }

    public void awaitForAllStarted(Duration atMost) {
        try {
            Awaitility.await().atMost(atMost).pollDelay(Durations.ONE_SECOND).until(() -> SandboxApp.allReadyToUse(this.context));
        }
        catch (Throwable ex) {
            log.error("Sandbox start failed");
            this.reportSandboxFailedApps();
            log.error("Re-run it with environment variable {}=INFO for more details", (Object)"SANDBOX_LOG_LEVEL");
            throw ex;
        }
    }

    public void awaitForAllStopped(Duration atMost) {
        try {
            Awaitility.await().atMost(atMost).pollDelay(Durations.ONE_SECOND).until(() -> 0L == SandboxApp.countReadyToUse(this.context));
        }
        catch (Throwable ex) {
            log.error("Sandbox stop failed");
            throw ex;
        }
    }

    private void reportSandboxFailedApps() {
        ALL.forEach(it -> {
            if (!it.isReadyToUse(this.context)) {
                log.error("Sandbox application {} has failed", (Object)it.name());
            }
        });
    }

    public void awaitForAllStarted() {
        this.awaitForAllStarted(Durations.FIVE_MINUTES);
    }

    public void awaitForAllStopped() {
        this.awaitForAllStopped(Durations.FIVE_MINUTES);
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.context.getDockerContainer().forEach((key, container) -> container.stop());
        this.executor.shutdown();
        this.executor.awaitTermination(Durations.ONE_MINUTE.getSeconds(), TimeUnit.SECONDS);
    }
}

